/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.player.hidder;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import ru.cwcode.cwutils.player.hidder.HideOption;

public final class HideOptions<Option extends HideOption> {
    private final Map<UUID, List<Option>> hiddenPlayers = new HashMap<UUID, List<Option>>();

    public boolean hasOptions(UUID hidden) {
        return !this.getHideOptions(hidden).isEmpty();
    }

    public void hide(UUID hidden, Option option) {
        this.hiddenPlayers.computeIfAbsent(hidden, k -> new LinkedList()).add(option);
    }

    public void show(UUID hidden, Predicate<Option> showIf) {
        List<Option> hideOptions = this.getHideOptions(hidden);
        hideOptions.removeIf(showIf);
        if (hideOptions.isEmpty()) {
            this.hiddenPlayers.remove(hidden);
        }
    }

    public void show(UUID hidden) {
        this.show(hidden, option -> true);
    }

    public boolean isEmpty(UUID hidden) {
        return this.getHideOptions(hidden).isEmpty();
    }

    public boolean isEmpty() {
        return this.hiddenPlayers.isEmpty();
    }

    public List<Option> getHideOptions(UUID hidden) {
        List<Option> hideOptions = this.getOptions(hidden);
        hideOptions.removeIf(option -> !option.isValid());
        if (hideOptions.isEmpty()) {
            this.hiddenPlayers.remove(hidden);
        }
        return hideOptions;
    }

    public Map<UUID, List<Option>> getHideOptions() {
        if (this.hiddenPlayers.isEmpty()) {
            return Map.of();
        }
        HashMap<UUID, List> hiddenPlayers = new HashMap<UUID, List>();
        for (UUID hidden : new HashSet<UUID>(this.hiddenPlayers.keySet())) {
            hiddenPlayers.computeIfAbsent(hidden, k -> new LinkedList()).addAll(this.getHideOptions(hidden));
        }
        return Collections.unmodifiableMap(hiddenPlayers);
    }

    private List<Option> getOptions(UUID hidden) {
        List options = this.hiddenPlayers.getOrDefault(hidden, new LinkedList());
        if (this.hiddenPlayers.containsKey(hidden) && options.isEmpty()) {
            this.hiddenPlayers.remove(hidden);
        }
        return options;
    }
}

