/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.protocol;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedRegistrable;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.destroystokyo.paper.profile.PlayerProfile;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rotatable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;
import ru.cwcode.cwutils.numbers.NumbersUtils;
import ru.cwcode.cwutils.player.PlayerUtils;
import ru.cwcode.cwutils.server.PaperServerUtils;

public class Packet {
    public static void setSlot(Player player, int slot, ItemStack item) {
        Packet.setSlot(player, slot, item, 0);
    }

    public static void setSlot(Player player, int slot, ItemStack item, int windowID) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.SET_SLOT);
        packet.getIntegers().write(0, (Object)windowID);
        if (PaperServerUtils.isVersionGreater_1_16_5()) {
            packet.getIntegers().write(1, (Object)0);
            packet.getIntegers().write(2, (Object)slot);
        } else {
            packet.getIntegers().write(1, (Object)slot);
        }
        packet.getItemModifier().write(0, (Object)item);
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
    }

    public static void updateSlot(Player player, int slot) {
        Packet.updateSlot(player, slot, 0);
    }

    public static void updateSlot(Player player, int slot, int windowID) {
        Packet.setSlot(player, slot, player.getInventory().getItem(slot), windowID);
    }

    public static void clearInventory(Player player) {
        Packet.clearInventory(player, 0);
    }

    public static void clearInventory(Player player, int windowID) {
        PlayerInventory inventory = player.getInventory();
        ItemStack air = new ItemStack(Material.AIR);
        for (int slot = 0; slot < 36; ++slot) {
            ItemStack item = inventory.getItem(slot);
            if (item == null || !item.getType().isItem()) continue;
            Packet.setSlot(player, slot, air, windowID);
        }
    }

    public static void spawnLivingEntity(Player player, int id, int entityId, Location loc) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY_LIVING);
        packet.getIntegers().write(0, (Object)id);
        packet.getIntegers().write(1, (Object)entityId);
        packet.getIntegers().write(2, (Object)0);
        packet.getUUIDs().write(0, (Object)UUID.randomUUID());
        packet.getDoubles().write(0, (Object)loc.getX());
        packet.getDoubles().write(1, (Object)loc.getY());
        packet.getDoubles().write(2, (Object)loc.getZ());
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
    }

    public static void destroyEntity(Player player, int id) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        packet.getIntegerArrays().write(0, (Object)new int[]{id});
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
    }

    public static void setEntityStatus(Player receiver, Entity entity, byte status) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet.getIntegers().write(0, (Object)entity.getEntityId());
        WrappedDataWatcher watcher = new WrappedDataWatcher();
        WrappedDataWatcher.Serializer serializer = WrappedDataWatcher.Registry.get(Byte.class);
        watcher.setEntity(entity);
        watcher.setObject(0, serializer, (Object)status);
        packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
        ProtocolLibrary.getProtocolManager().sendServerPacket(receiver, packet);
    }

    public static void setEntityFrozen(Player receiver, Entity entity, int ticksFrozen) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet.getIntegers().write(0, (Object)entity.getEntityId());
        WrappedDataWatcher watcher = new WrappedDataWatcher();
        WrappedDataWatcher.Serializer serializer = WrappedDataWatcher.Registry.get(Integer.class);
        watcher.setEntity(entity);
        watcher.setObject(7, serializer, (Object)ticksFrozen);
        packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
        ProtocolLibrary.getProtocolManager().sendServerPacket(receiver, packet);
    }

    public static void teleportEntity(Player receiver, int entityId, Location location) {
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        PacketContainer packet = manager.createPacket(PacketType.Play.Server.ENTITY_TELEPORT);
        packet.getIntegers().write(0, (Object)entityId);
        packet.getDoubles().write(0, (Object)location.getX()).write(1, (Object)location.getY()).write(2, (Object)location.getZ());
        manager.sendServerPacket(receiver, packet);
    }

    public static void moveEntity(Player receiver, int entityId, Vector vector) {
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        PacketContainer packet = manager.createPacket(PacketType.Play.Server.REL_ENTITY_MOVE);
        packet.getIntegers().write(0, (Object)entityId);
        packet.getShorts().write(0, (Object)((short)(vector.getX() * 4096.0))).write(1, (Object)((short)(vector.getY() * 4096.0))).write(2, (Object)((short)(vector.getZ() * 4096.0)));
        packet.getBooleans().write(0, (Object)false);
        packet.getBooleans().write(1, (Object)false);
        manager.sendServerPacket(receiver, packet);
    }

    public static void setHead(Player receiver, PlayerProfile playerProfile, Location location, BlockFace rotation) {
        receiver.sendBlockChange(location, Material.PLAYER_HEAD.createBlockData(blockData -> ((Rotatable)blockData).setRotation(rotation)));
        Packet.updateHead(receiver, playerProfile, location);
    }

    public static void updateHead(Player receiver, PlayerProfile playerProfile, Location location) {
        if (playerProfile == null) {
            return;
        }
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        PacketContainer packet = manager.createPacket(PacketType.Play.Server.TILE_ENTITY_DATA);
        packet.getBlockPositionModifier().write(0, (Object)new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
        if (PaperServerUtils.isVersionGreater("1.17.1")) {
            packet.getBlockEntityTypeModifier().write(0, (Object)WrappedRegistrable.blockEntityType((String)"skull"));
        } else {
            packet.getIntegers().write(0, (Object)4);
        }
        NbtCompound base = NbtFactory.ofCompound((String)"");
        base.put("x", location.getBlockX());
        base.put("y", location.getBlockY());
        base.put("z", location.getBlockZ());
        base.put("id", "minecraft:skull");
        NbtCompound nbt = NbtFactory.ofCompound((String)"SkullOwner");
        nbt.put("Id", NumbersUtils.convertToInts(playerProfile.getId()));
        nbt.put("Name", "");
        NbtCompound properties = NbtFactory.ofCompound((String)"Properties");
        NbtCompound skin = NbtFactory.ofCompound((String)"");
        skin.put("Value", PlayerUtils.getTextureValue(playerProfile));
        properties.put("textures", (NbtBase)NbtFactory.ofList((String)"textures", (Object[])new NbtCompound[]{skin}));
        nbt.put("Properties", (NbtBase)properties);
        base.put("SkullOwner", (NbtBase)nbt);
        packet.getNbtModifier().write(0, (Object)base);
        try {
            manager.sendServerPacket(receiver, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void blockUpdate(Collection<? extends Player> players, Location location, BlockData blockData) {
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        PacketContainer blockUpdatePacket = Packet.getBlockUpdatePacket(location, blockData);
        manager.broadcastServerPacket(blockUpdatePacket, players);
    }

    public static PacketContainer getBlockUpdatePacket(Location location, BlockData blockData) {
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        PacketContainer packet = manager.createPacket(PacketType.Play.Server.BLOCK_CHANGE);
        packet.getBlockPositionModifier().write(0, (Object)new BlockPosition(location.toVector()));
        packet.getBlockData().write(0, (Object)WrappedBlockData.createData((Object)blockData));
        return packet;
    }
}

