/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.commands.ArgumentSet;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.CommandParser;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.preconditions.PreconditionRequirements;
import ru.cwcode.cwutils.text.StringUtils;

public abstract class TabCompleter {
    private final Command command;
    private int maxLinesPerCompletions = 64;

    public TabCompleter(Command command) {
        this.command = command;
    }

    public void setMaxCompletionsEntries(int maxLinesPerCompletions) {
        this.maxLinesPerCompletions = maxLinesPerCompletions;
    }

    public List<String> onTabComplete(@NotNull Sender sender, String[] args) {
        ArrayList<String> complete = new ArrayList<String>();
        CommandParser.Result parseResult = CommandParser.parse(this.command, sender, args);
        Command foundedCommand = parseResult.getCommand();
        int deep = parseResult.getDeep();
        if (args.length <= deep) {
            return complete;
        }
        args = Arrays.copyOfRange(args, deep, args.length);
        List<String> arguments = Arrays.asList(args);
        if (arguments.size() == 1) {
            for (Command cmd : foundedCommand.getSubcommandsFor(sender, PreconditionRequirements.CAN_PERFORM_AND_CAN_SEE)) {
                complete.add(cmd.name);
                complete.addAll(cmd.aliases);
            }
        }
        for (ArgumentSet set : foundedCommand.getArgumentSetsFor(sender, PreconditionRequirements.CAN_PERFORM_AND_CAN_SEE)) {
            complete.addAll(set.getCompletesFor(arguments, sender));
        }
        List<String> suggestions = StringUtils.getSuggestions(complete, arguments.get(arguments.size() - 1), this.maxLinesPerCompletions);
        return suggestions;
    }
}

