/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.color;

import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.HSVLike;
import ru.cwcode.commands.color.ColorGenerationStrategy;
import ru.cwcode.commands.color.DefaultColorGenerationStrategy;

public class ColoredScheme
implements ColorGenerationStrategy {
    private final TextColor main;
    private final TextColor argument;
    private final TextColor optional;
    private final TextColor subcommand;
    private final TextColor written;
    private final TextColor permissions;
    private final TextColor accent;
    private final TextColor argumentWithNoPermissions;
    private final TextColor optionalWithNoPermissions;
    private final TextColor subcommandWithNoPermissions;
    private final TextColor writtenWithNoPermissions;
    private final TextColor permissionsWithNoPermissions;
    private final TextColor accentWithNoPermissions;

    public ColoredScheme(TextColor baseColor, TextColor baseNoPermissionColor) {
        this.main = this.generateColor(baseColor, DefaultColorGenerationStrategy.main);
        this.argument = this.generateColor(baseColor, DefaultColorGenerationStrategy.argument);
        this.optional = this.generateColor(baseColor, DefaultColorGenerationStrategy.optional);
        this.subcommand = this.generateColor(baseColor, DefaultColorGenerationStrategy.subcommand);
        this.written = this.generateColor(baseColor, DefaultColorGenerationStrategy.written);
        this.permissions = this.generateColor(baseColor, DefaultColorGenerationStrategy.permissions);
        this.accent = this.generateColor(baseColor, DefaultColorGenerationStrategy.accent);
        this.argumentWithNoPermissions = this.generateColor(baseNoPermissionColor, DefaultColorGenerationStrategy.argumentWithNoPermissions);
        this.optionalWithNoPermissions = this.generateColor(baseNoPermissionColor, DefaultColorGenerationStrategy.optionalWithNoPermissions);
        this.subcommandWithNoPermissions = this.generateColor(baseNoPermissionColor, DefaultColorGenerationStrategy.subcommandWithNoPermissions);
        this.writtenWithNoPermissions = this.generateColor(baseNoPermissionColor, DefaultColorGenerationStrategy.writtenWithNoPermissions);
        this.permissionsWithNoPermissions = this.generateColor(baseNoPermissionColor, DefaultColorGenerationStrategy.permissionsWithNoPermissions);
        this.accentWithNoPermissions = this.generateColor(baseNoPermissionColor, DefaultColorGenerationStrategy.accentWithNoPermissions);
    }

    public ColoredScheme(TextColor baseColor) {
        this(baseColor, baseColor);
    }

    private TextColor generateColor(TextColor h, TextColor sv) {
        HSVLike hsvH = h.asHSV();
        HSVLike hsvSV = sv.asHSV();
        HSVLike combined = HSVLike.of(hsvH.h(), hsvSV.s(), hsvSV.v());
        return TextColor.color(combined);
    }

    @Override
    public TextColor main() {
        return this.main;
    }

    @Override
    public TextColor argument(boolean canPerformedBy) {
        return canPerformedBy ? this.argument : this.argumentWithNoPermissions;
    }

    @Override
    public TextColor optional(boolean canPerformedBy) {
        return canPerformedBy ? this.optional : this.optionalWithNoPermissions;
    }

    @Override
    public TextColor subcommand(boolean canPerformedBy) {
        return canPerformedBy ? this.subcommand : this.subcommandWithNoPermissions;
    }

    @Override
    public TextColor written(boolean canPerformedBy) {
        return canPerformedBy ? this.written : this.writtenWithNoPermissions;
    }

    @Override
    public TextColor permissions(boolean canPerformedBy) {
        return canPerformedBy ? this.permissions : this.permissionsWithNoPermissions;
    }

    @Override
    public TextColor accent(boolean canPerformedBy) {
        return canPerformedBy ? this.accent : this.accentWithNoPermissions;
    }
}

