/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.extra.builder.list;

import org.jetbrains.annotations.NotNull;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.color.ColorGenerationStrategy;

public class ListContext {
    final Command command;
    final int pages;
    final int page;

    public ListContext(Command command, int page, int pages) {
        this.command = command;
        this.pages = pages;
        this.page = page;
    }

    public int pages() {
        return this.pages;
    }

    public int page() {
        return this.page;
    }

    public Command command() {
        return this.command;
    }

    public ColorGenerationStrategy colorScheme() {
        return this.command.getColorScheme();
    }

    public String pageCommand(int page) {
        return this.fullCommandPath() + " " + page;
    }

    @NotNull
    public String fullCommandPath() {
        return "/" + this.command.getFullCommandPath(this.command.getRootCommand().getName()) + " list";
    }

    public String nextPageCommand() {
        return this.pageCommand(Math.min(this.pages, this.page + 1));
    }

    public String prevPageCommand() {
        return this.pageCommand(Math.max(1, this.page - 1));
    }

    public String firstPageCommand() {
        return this.pageCommand(1);
    }

    public String lastPageCommand() {
        return this.pageCommand(this.pages);
    }
}

