/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.bounceable;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import ru.cwcode.cwutils.bounceable.BounceableListener;

public interface Bounceable<T extends Entity, EVENT extends EntityEvent> {
    public void onExecute(EVENT var1);

    default public double getVelocityMultiplier() {
        return 1.0;
    }

    public Class<T> getEntityClass();

    default public T spawnEntity(Location location, Player player, ItemStack itemStack) {
        return (T)location.getWorld().spawn(location, this.getEntityClass());
    }

    default public void bounce(Player player, ItemStack itemStack) {
        Location location = player.getEyeLocation();
        Vector velocity = location.getDirection().normalize().multiply(this.getVelocityMultiplier());
        T entity = this.spawnEntity(location, player, itemStack);
        entity.setVelocity(velocity);
        BounceableListener.addBouncedEntity(entity, this);
        itemStack.subtract();
    }
}

