/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.bungeecord;

import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class BungeeCordMainChannel {
    public static final String CHANNEL = "BungeeCord";
    private static final long DEFAULT_TIMEOUT_MS = 5000L;
    private static final Map<String, Deque<PendingRequest<?>>> PENDING = new ConcurrentHashMap();
    private static final Map<String, BiConsumer<ByteArrayDataInput, Player>> HANDLERS = new HashMap<String, BiConsumer<ByteArrayDataInput, Player>>();
    private static volatile boolean registered = false;

    private BungeeCordMainChannel() {
    }

    public static void connect(Plugin pl, Player p, String server) {
        BungeeCordMainChannel.sendCmd(pl, p, "Connect", server);
    }

    public static void connectOther(Plugin pl, Player p, String playerName, String server) {
        BungeeCordMainChannel.sendCmd(pl, p, "ConnectOther", playerName, server);
    }

    public static void message(Plugin pl, Player p, String target, String msg) {
        BungeeCordMainChannel.sendCmd(pl, p, "Message", target, msg);
    }

    public static void messageRaw(Plugin pl, Player p, String target, String json) {
        BungeeCordMainChannel.sendCmd(pl, p, "MessageRaw", target, json);
    }

    public static void kickPlayer(Plugin pl, Player p, String target, String reason) {
        BungeeCordMainChannel.sendCmd(pl, p, "KickPlayer", target, reason);
    }

    public static void kickPlayerRaw(Plugin pl, Player p, String target, String json) {
        BungeeCordMainChannel.sendCmd(pl, p, "KickPlayerRaw", target, json);
    }

    public static CompletableFuture<PlayerIp> ip(Plugin pl, Player p) {
        return BungeeCordMainChannel.sendRequest(pl, p, "IP", p.getName(), new Object[0]);
    }

    public static CompletableFuture<PlayerIpOther> ipOther(Plugin pl, Player p, String other) {
        return BungeeCordMainChannel.sendRequest(pl, p, "IPOther", other, other);
    }

    public static CompletableFuture<PlayerCount> playerCount(Plugin pl, Player p, String server) {
        return BungeeCordMainChannel.sendRequest(pl, p, "PlayerCount", server, server);
    }

    public static CompletableFuture<PlayerListResult> playerList(Plugin pl, Player p, String server) {
        return BungeeCordMainChannel.sendRequest(pl, p, "PlayerList", server, server);
    }

    public static CompletableFuture<PlayerServer> getPlayerServer(Plugin pl, Player p, String name) {
        return BungeeCordMainChannel.sendRequest(pl, p, "GetPlayerServer", name, name);
    }

    public static CompletableFuture<List<String>> getServers(Plugin pl, Player p) {
        return BungeeCordMainChannel.sendRequest(pl, p, "GetServers", null, new Object[0]);
    }

    public static CompletableFuture<String> getServer(Plugin pl, Player p) {
        return BungeeCordMainChannel.sendRequest(pl, p, "GetServer", p.getName(), new Object[0]);
    }

    public static CompletableFuture<String> uuid(Plugin pl, Player p) {
        return BungeeCordMainChannel.sendRequest(pl, p, "UUID", p.getName(), new Object[0]);
    }

    public static CompletableFuture<PlayerUuid> uuidOther(Plugin pl, Player p, String name) {
        return BungeeCordMainChannel.sendRequest(pl, p, "UUIDOther", name, name);
    }

    public static CompletableFuture<ServerIp> serverIp(Plugin pl, Player p, String server) {
        return BungeeCordMainChannel.sendRequest(pl, p, "ServerIP", server, server);
    }

    public static void forward(Plugin pl, Player p, String target, String subchannel, byte[] payload) {
        BungeeCordMainChannel.sendCmd(pl, p, "Forward", target, subchannel, (short)payload.length, payload);
    }

    public static void forwardToPlayer(Plugin pl, Player p, String target, String subchannel, byte[] payload) {
        BungeeCordMainChannel.sendCmd(pl, p, "ForwardToPlayer", target, subchannel, (short)payload.length, payload);
    }

    public static void handleIncoming(String channel, Player player, byte[] data) {
        if (!CHANNEL.equals(channel)) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
        String sub = in.readUTF();
        HANDLERS.getOrDefault(sub, (i, p) -> {}).accept(in, player);
    }

    private static void sendCmd(Plugin pl, Player carrier, Object ... parts) {
        BungeeCordMainChannel.ensureRegistered(pl);
        Player c = BungeeCordMainChannel.resolveCarrier(carrier);
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        for (Object part : parts) {
            BungeeCordMainChannel.writePart(out, part);
        }
        c.sendPluginMessage(pl, CHANNEL, out.toByteArray());
    }

    private static <T> CompletableFuture<T> sendRequest(Plugin pl, Player carrier, String cmd, String key, Object ... parts) {
        CompletableFuture<T> fut = BungeeCordMainChannel.await(cmd, key);
        BungeeCordMainChannel.sendCmd(pl, carrier, BungeeCordMainChannel.merge(new Object[]{cmd}, parts));
        return fut;
    }

    private static void writePart(ByteArrayDataOutput out, Object p) {
        if (p instanceof String) {
            String s = (String)p;
            out.writeUTF(s);
        } else if (p instanceof Short) {
            Short s = (Short)p;
            out.writeShort((int)s.shortValue());
        } else if (p instanceof byte[]) {
            byte[] b = (byte[])p;
            out.write(b);
        }
    }

    private static Object[] merge(Object[] a, Object[] b) {
        Object[] r = Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, r, a.length, b.length);
        return r;
    }

    private static void ensureRegistered(Plugin plugin) {
        if (registered) {
            return;
        }
        registered = true;
        Bukkit.getMessenger().registerOutgoingPluginChannel(plugin, CHANNEL);
        Bukkit.getMessenger().registerIncomingPluginChannel(plugin, CHANNEL, BungeeCordMainChannel::handleIncoming);
    }

    private static Player resolveCarrier(Player preferred) {
        if (preferred != null && preferred.isOnline()) {
            return preferred;
        }
        Player any = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        if (any == null) {
            throw new IllegalStateException("\u041d\u0435\u0442 \u043e\u043d\u043b\u0430\u0439\u043d-\u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 plugin message");
        }
        return any;
    }

    private static <T> CompletableFuture<T> await(String sub, String key) {
        PendingRequest pr = new PendingRequest(key);
        PENDING.computeIfAbsent(sub, k -> new ConcurrentLinkedDeque()).add(pr);
        pr.future.orTimeout(5000L, TimeUnit.MILLISECONDS).whenComplete((r, e) -> ((Deque)PENDING.getOrDefault(sub, new ConcurrentLinkedDeque())).remove(pr));
        return pr.future;
    }

    private static <T> void complete(String sub, String key, T val) {
        Deque<PendingRequest<?>> q = PENDING.get(sub);
        if (q == null) {
            return;
        }
        Iterator<PendingRequest<?>> it = q.iterator();
        while (it.hasNext()) {
            PendingRequest<?> pr = it.next();
            if (!Objects.equals(pr.correlationKey, key) && (key != null || pr.correlationKey != null)) continue;
            it.remove();
            pr.future.complete(val);
            return;
        }
    }

    static {
        HANDLERS.put("IP", (in, p) -> BungeeCordMainChannel.complete("IP", p.getName(), new PlayerIp(in.readUTF(), in.readInt())));
        HANDLERS.put("IPOther", (in, p) -> {
            String name = in.readUTF();
            BungeeCordMainChannel.complete("IPOther", name, new PlayerIpOther(name, in.readUTF(), in.readInt()));
        });
        HANDLERS.put("PlayerCount", (in, p) -> {
            String server = in.readUTF();
            BungeeCordMainChannel.complete("PlayerCount", server, new PlayerCount(server, in.readInt()));
        });
        HANDLERS.put("PlayerList", (in, p) -> {
            String server = in.readUTF();
            String csv = in.readUTF();
            List<String> players = csv.isEmpty() ? List.of() : Arrays.asList(csv.split(", "));
            BungeeCordMainChannel.complete("PlayerList", server, new PlayerListResult(server, players));
        });
        HANDLERS.put("GetPlayerServer", (in, p) -> {
            String name = in.readUTF();
            BungeeCordMainChannel.complete("GetPlayerServer", name, new PlayerServer(name, in.readUTF()));
        });
        HANDLERS.put("GetServers", (in, p) -> {
            String csv = in.readUTF();
            List servers = csv.isEmpty() ? List.of() : Arrays.asList(csv.split(", "));
            BungeeCordMainChannel.complete("GetServers", null, servers);
        });
        HANDLERS.put("GetServer", (in, p) -> BungeeCordMainChannel.complete("GetServer", p.getName(), in.readUTF()));
        HANDLERS.put("UUID", (in, p) -> BungeeCordMainChannel.complete("UUID", p.getName(), in.readUTF()));
        HANDLERS.put("UUIDOther", (in, p) -> {
            String name = in.readUTF();
            BungeeCordMainChannel.complete("UUIDOther", name, new PlayerUuid(name, in.readUTF()));
        });
        HANDLERS.put("ServerIP", (in, p) -> {
            String name = in.readUTF();
            BungeeCordMainChannel.complete("ServerIP", name, new ServerIp(name, in.readUTF(), in.readUnsignedShort()));
        });
    }

    private static final class PendingRequest<T> {
        final String correlationKey;
        final CompletableFuture<T> future = new CompletableFuture();

        PendingRequest(String key) {
            this.correlationKey = key;
        }
    }

    public record ServerIp(String serverName, String ip, int port) {
    }

    public record PlayerUuid(String userName, String uuid) {
    }

    public record PlayerServer(String userName, String serverName) {
    }

    public record PlayerListResult(String server, List<String> players) {
    }

    public record PlayerCount(String server, int count) {
    }

    public record PlayerIpOther(String userName, String address, int port) {
    }

    public record PlayerIp(String ip, int port) {
    }
}

