/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.files;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class PastesDevClient {
    private static final String DEFAULT_URL = "https://pastes.dev";
    private static final String DEFAULT_API_URL = "https://api.pastes.dev";
    private static final HttpClient SHARED_CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();

    public static String createPaste(String content, String language) throws IOException, InterruptedException {
        return PastesDevClient.createPaste(content, language, DEFAULT_API_URL, DEFAULT_URL);
    }

    public static String createPaste(String content, String language, String apiUrl, String url) throws IOException, InterruptedException {
        String location;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl + "/post")).header("Content-Type", "text/" + language).header("User-Agent", "Shared Paste Client (github.com/KamikotoTkach)").POST(HttpRequest.BodyPublishers.ofString(content)).build();
        HttpResponse<String> response = SHARED_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() == 201 && (location = (String)response.headers().firstValue("Location").orElse(null)) != null) {
            return url + "/" + location;
        }
        throw new IOException("Failed to create paste. Status: " + response.statusCode() + ", Body: " + response.body());
    }

    public static class PasteLanguage {
        public static String plain = "plain";
        public static String log = "log";
        public static String yaml = "yaml";
        public static String json = "json";
        public static String xml = "xml";
        public static String ini = "ini";
        public static String java = "java";
        public static String javascript = "javascript";
        public static String typescript = "typescript";
        public static String python = "python";
        public static String kotlin = "kotlin";
        public static String scala = "scala";
        public static String cpp = "cpp";
        public static String csharp = "csharp";
        public static String shell = "shell";
        public static String ruby = "ruby";
        public static String rust = "rust";
        public static String sql = "sql";
        public static String go = "go";
        public static String lua = "lua";
        public static String swift = "swift";
        public static String c = "c";
        public static String html = "html";
        public static String css = "css";
        public static String scss = "scss";
        public static String php = "php";
        public static String graphql = "graphql";
        public static String diff = "diff";
        public static String dockerfile = "dockerfile";
        public static String markdown = "markdown";
        public static String proto = "proto";
    }
}

