/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.items.rechargable;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import ru.cwcode.cwutils.datetime.TimeFormatter;

public class PlayerRecharge {
    private UUID player;
    private final Map<String, Long> timestamps = new HashMap<String, Long>();

    private PlayerRecharge() {
    }

    public PlayerRecharge(UUID player) {
        this.player = player;
    }

    public PlayerRecharge(Player player) {
        this(player.getUniqueId());
    }

    public UUID getPlayer() {
        return this.player;
    }

    public long getTimestamp(String rechargeKey) {
        return this.timestamps.getOrDefault(rechargeKey, 0L);
    }

    public long getRechargeExpire(String rechargeKey, long recharge) {
        return this.getTimestamp(rechargeKey) + recharge * 1000L;
    }

    public boolean isInRecharge(String rechargeKey, long recharge) {
        long rechargeExpire = this.getRechargeExpire(rechargeKey, recharge);
        return rechargeExpire > System.currentTimeMillis();
    }

    public void setRecharge(String rechargeKey) {
        this.timestamps.put(rechargeKey, System.currentTimeMillis());
    }

    public long getRechargeRemain(String rechargeKey, long recharge) {
        long expire = this.getRechargeExpire(rechargeKey, recharge);
        return Math.max(expire - System.currentTimeMillis(), 0L);
    }

    public String getRechargeRemainTime(Duration duration) {
        return TimeFormatter.getFormattedTime(duration);
    }

    public String getRechargeRemainTime(String rechargeKey, long recharge) {
        long rechargeRemain = this.getRechargeRemain(rechargeKey, recharge);
        return this.getRechargeRemainTime(Duration.ofMillis(rechargeRemain));
    }
}

