/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.player.hidder;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.cwcode.cwutils.player.hidder.HideOption;
import ru.cwcode.cwutils.player.hidder.HideOptions;
import ru.cwcode.cwutils.player.hidder.HideType;
import ru.cwcode.cwutils.player.hidder.HiderListener;

public class PlayerHider<Option extends HideOption> {
    private final JavaPlugin plugin;
    private final HideOptions<Option> hiddenForAllPlayers = new HideOptions();
    private final Map<UUID, HideOptions<Option>> options = new HashMap<UUID, HideOptions<Option>>();
    private final Map<UUID, Set<UUID>> cache = new HashMap<UUID, Set<UUID>>();

    public PlayerHider(JavaPlugin plugin, long period) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)new HiderListener(this), (Plugin)plugin);
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, this::scheduler, 0L, period);
    }

    public HideOptions<Option> getHiddenPlayers(UUID player) {
        HideOptions hideOptions = this.options.getOrDefault(player, new HideOptions());
        if (this.options.containsKey(player) && hideOptions.isEmpty()) {
            this.options.remove(player);
        }
        return hideOptions;
    }

    public HideOptions<Option> getHiddenPlayers(Player onlinePlayer) {
        return this.getHiddenPlayers(onlinePlayer.getUniqueId());
    }

    public boolean isHiddenFor(UUID hidden, UUID player) {
        if (hidden.equals(player)) {
            return false;
        }
        boolean isHiddenForAll = this.isHiddenForAll(hidden);
        HideOptions<Option> hideOptions = this.getHiddenPlayers(player);
        List<Option> options = hideOptions.getHideOptions(hidden);
        if (options.isEmpty()) {
            return isHiddenForAll;
        }
        HideOption hideOption = (HideOption)options.get(options.size() - 1);
        if (hideOption.getType() == HideType.HIDE_ONLY_FOR) {
            return true;
        }
        if (hideOption.getType() == HideType.VIEW_ONLY_FOR) {
            return false;
        }
        return isHiddenForAll;
    }

    public boolean isHiddenFor(Player hiddenPlayer, Player onlinePlayer) {
        return this.isHiddenFor(hiddenPlayer.getUniqueId(), onlinePlayer.getUniqueId());
    }

    public boolean isHiddenForAll(UUID hidden) {
        return !this.hiddenForAllPlayers.isEmpty(hidden);
    }

    public boolean isHiddenForAll(Player hiddenPlayer) {
        return this.isHiddenForAll(hiddenPlayer.getUniqueId());
    }

    public void hide(Player hiddenPlayer, Option hideOption, Player ... players) {
        UUID hidden = hiddenPlayer.getUniqueId();
        HideType type = ((HideOption)hideOption).getType();
        if (type == HideType.VIEW_ONLY_FOR) {
            this.hiddenForAllPlayers.hide(hidden, hideOption);
        }
        for (Player onlinePlayer : players) {
            UUID player = onlinePlayer.getUniqueId();
            if (hidden.equals(player)) continue;
            HideOptions<Option> hideOptions = this.gerOrCreateHiddenPlayers(player);
            hideOptions.hide(hidden, hideOption);
            Set<UUID> cash = this.getOrCreateCache(hidden);
            cash.add(hidden);
            this.updateHidden(hiddenPlayer);
        }
    }

    public void hide(Player hiddenPlayer, Option hideOption, Collection<Player> players) {
        this.hide(hiddenPlayer, hideOption, players.toArray(new Player[0]));
    }

    public void hideGroup(Option hideOption, Player ... players) {
        for (Player onlinePlayer : players) {
            this.hide(onlinePlayer, hideOption, players);
        }
    }

    public void hideGroup(Option hideOption, Collection<Player> players) {
        this.hideGroup(hideOption, players.toArray(new Player[0]));
    }

    public void showFor(Player hiddenPlayer, Player onlinePlayer) {
        UUID hidden = hiddenPlayer.getUniqueId();
        UUID player = onlinePlayer.getUniqueId();
        onlinePlayer.showPlayer((Plugin)this.plugin, hiddenPlayer);
        this.getHiddenPlayers(player).show(hidden);
        this.getCache(hidden).remove(player);
    }

    public void show(Player hiddenPlayer, Predicate<Option> showIf) {
        Set<UUID> cache;
        UUID hidden = hiddenPlayer.getUniqueId();
        boolean changed = false;
        if (this.hiddenForAllPlayers.hasOptions(hidden)) {
            this.hiddenForAllPlayers.show(hidden, showIf);
            changed = true;
        }
        if (!(cache = this.getCache(hidden)).isEmpty()) {
            for (UUID player : new HashSet<UUID>(cache)) {
                HideOptions<Option> hideOptions = this.getHiddenPlayers(player);
                hideOptions.show(hidden, showIf);
                if (!hideOptions.isEmpty(hidden)) continue;
                cache.remove(player);
                changed = true;
            }
        }
        if (changed) {
            this.updateHidden(hiddenPlayer);
        }
    }

    public void show(Player hiddenPlayer) {
        this.show(hiddenPlayer, option -> true);
    }

    public void updateHidden(Player hiddenPlayer) {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            boolean isHidden = this.isHiddenFor(hiddenPlayer, onlinePlayer);
            if (isHidden) {
                onlinePlayer.hidePlayer((Plugin)this.plugin, hiddenPlayer);
                continue;
            }
            onlinePlayer.showPlayer((Plugin)this.plugin, hiddenPlayer);
        }
    }

    public void updateViewer(Player onlinePlayer) {
        for (Player hiddenPlayer : Bukkit.getOnlinePlayers()) {
            boolean isHidden = this.isHiddenFor(hiddenPlayer, onlinePlayer);
            if (isHidden) {
                onlinePlayer.hidePlayer((Plugin)this.plugin, hiddenPlayer);
                continue;
            }
            onlinePlayer.showPlayer((Plugin)this.plugin, hiddenPlayer);
        }
    }

    private void scheduler() {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            this.updateHidden(onlinePlayer);
        }
    }

    private HideOptions<Option> gerOrCreateHiddenPlayers(UUID player) {
        return this.options.computeIfAbsent(player, k -> new HideOptions());
    }

    private Set<UUID> getCache(UUID hidden) {
        Set cache = this.cache.getOrDefault(hidden, new HashSet());
        if (this.cache.containsKey(hidden) && cache.isEmpty()) {
            this.cache.remove(hidden);
        }
        return cache;
    }

    private Set<UUID> getOrCreateCache(UUID hidden) {
        return this.cache.computeIfAbsent(hidden, k -> new HashSet());
    }
}

