/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.velocityplatform.velocity;

import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.proxy.ProxyServer;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.api.Logger;
import ru.cwcode.commands.api.Platform;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.velocityplatform.VelocityMain;
import ru.cwcode.commands.velocityplatform.velocity.VelocityCommand;
import ru.cwcode.commands.velocityplatform.velocity.VelocityLogger;
import ru.cwcode.cwutils.messages.MessageReturn;

public class VelocityPlatform
extends Platform {
    private final VelocityMain plugin;
    private final ProxyServer server;
    private final Logger logger;

    public VelocityPlatform(VelocityMain plugin, ProxyServer server, org.slf4j.Logger logger) {
        this.plugin = plugin;
        this.server = server;
        this.logger = new VelocityLogger(logger);
    }

    public VelocityMain getPlugin() {
        return this.plugin;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void handleExecutionException(Exception exception, Command command, Sender sender) {
        if (exception instanceof MessageReturn) {
            MessageReturn messageReturn = (MessageReturn)exception;
            if (messageReturn.isStyled()) {
                sender.sendMessage(messageReturn.getComponentMessage());
            } else {
                sender.sendMessage(messageReturn.getComponentMessage().color(command.getColorScheme().main()));
            }
            return;
        }
        String localizedMessage = exception.getLocalizedMessage();
        if (localizedMessage == null) {
            localizedMessage = "\u00a7Error (no message in exception)";
        }
        sender.sendMessage(localizedMessage);
        CommandsAPI.getPlatform().getLogger().warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 " + this.getClass().getName());
        exception.printStackTrace();
    }

    @Override
    public void registerCommand(Command command) {
        try {
            CommandManager commandManager = this.server.getCommandManager();
            commandManager.register(commandManager.metaBuilder(command.getName()).aliases(command.aliases().toArray(new String[0])).plugin((Object)this.plugin).build(), (com.velocitypowered.api.command.Command)new VelocityCommand(command));
        }
        catch (Exception e) {
            this.getLogger().warn(String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443 %s \u0432 \u0432\u0438\u0434\u0443 \u0435\u0451 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u044f \u0432 plugin.yml", command.getName()));
        }
    }
}

