/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.world;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.generator.ChunkGenerator;
import org.jetbrains.annotations.NotNull;

public class WorldUtils {
    private static final ChunkGenerator emptyGenerator = new ChunkGenerator(){

        @NotNull
        public ChunkGenerator.ChunkData generateChunkData(@NotNull World world, @NotNull Random random, int x, int z, @NotNull ChunkGenerator.BiomeGrid biome) {
            return this.createChunkData(world);
        }
    };

    public static World createEmptyWorld(String name) {
        if (Bukkit.getWorld((String)name) != null) {
            return null;
        }
        World world = WorldCreator.name((String)name).type(WorldType.FLAT).generator(emptyGenerator).createWorld();
        if (world != null) {
            world.setGameRule(GameRule.RANDOM_TICK_SPEED, (Object)0);
            world.setGameRule(GameRule.DO_MOB_SPAWNING, (Object)false);
            world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
            world.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
            world.setTime(6000L);
            world.setClearWeatherDuration(1000);
        }
        return world;
    }

    public static World createWorld(String name, WorldType worldType) {
        if (Bukkit.getWorld((String)name) != null) {
            return null;
        }
        return WorldCreator.name((String)name).type(worldType).createWorld();
    }
}

