/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Collections;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.Nullable;

public class WorldGuardUtils {
    public static Set<ProtectedRegion> getRegionsAt(Location location) {
        RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)location.getWorld()));
        return regionManager == null ? Collections.emptySet() : regionManager.getApplicableRegions(BukkitAdapter.asBlockVector((Location)location)).getRegions();
    }

    public static boolean isInRegion(Location location, String region, String world) {
        return WorldGuardUtils.isInRegion(location, region, Bukkit.getWorld((String)world));
    }

    public static boolean isInRegion(Location location, String region, World world) {
        ProtectedRegion reg;
        if (location == null || region == null || location.getWorld() != world) {
            return false;
        }
        RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)location.getWorld()));
        return regionManager != null && (reg = regionManager.getRegion(region)) != null && reg.contains(BukkitAdapter.asBlockVector((Location)location));
    }

    @Nullable
    public static ProtectedRegion getRegion(String region, String world) {
        return WorldGuardUtils.getRegion(region, Bukkit.getWorld((String)world));
    }

    @Nullable
    public static ProtectedRegion getRegion(String region, World world) {
        if (region == null || world == null) {
            return null;
        }
        RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)world));
        if (regionManager == null) {
            return null;
        }
        return regionManager.getRegion(region);
    }
}

