/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.dynamicBossBar.broadcast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.cwutils.dynamicBossBar.broadcast.BroadcastBossBarBuilder;
import ru.cwcode.cwutils.numbers.NumbersUtils;

public class BroadcastBossBar {
    private final UUID uuid;
    private final Supplier<Component> title;
    private final Supplier<Float> progress;
    private final Supplier<Boolean> shouldRemove;
    private final Function<Player, Boolean> shouldDisplay;
    private final Supplier<BossBar.Color> color;
    private final Supplier<BossBar.Overlay> overlay;
    private final BossBar bossBar;
    private final Supplier<Collection<UUID>> viewers;
    private Collection<UUID> previousViewers = new ArrayList<UUID>();

    BroadcastBossBar(@NotNull UUID uuid, @NotNull Supplier<Component> title, @NotNull Supplier<Float> progress, @NotNull Supplier<Boolean> shouldRemove, @NotNull Function<Player, Boolean> shouldDisplay, @NotNull Supplier<BossBar.Color> color, @NotNull Supplier<BossBar.Overlay> overlay, @NotNull Supplier<Collection<UUID>> viewers) {
        this.uuid = uuid;
        this.title = title;
        this.progress = progress;
        this.shouldRemove = shouldRemove;
        this.shouldDisplay = shouldDisplay;
        this.color = color;
        this.overlay = overlay;
        this.viewers = viewers;
        this.bossBar = BossBar.bossBar(title.get(), progress.get().floatValue(), color.get(), overlay.get());
    }

    public static BroadcastBossBarBuilder of(Supplier<Component> title) {
        return new BroadcastBossBarBuilder().setTitle(title);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Supplier<Component> getTitle() {
        return this.title;
    }

    public Supplier<Float> getProgress() {
        return this.progress;
    }

    public Supplier<Boolean> getShouldRemove() {
        return this.shouldRemove;
    }

    public Function<Player, Boolean> getShouldDisplay() {
        return this.shouldDisplay;
    }

    public Supplier<BossBar.Color> getColor() {
        return this.color;
    }

    public Supplier<BossBar.Overlay> getOverlay() {
        return this.overlay;
    }

    public BossBar getBossBar() {
        return this.bossBar;
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BroadcastBossBar that = (BroadcastBossBar)o;
        return this.uuid.equals(that.uuid);
    }

    public void hide(Player player) {
        player.hideBossBar(this.bossBar);
    }

    public void onRemove() {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            this.hide(onlinePlayer);
        }
    }

    public void update() {
        this.bossBar.name(this.title.get());
        this.bossBar.color(this.color.get());
        this.bossBar.overlay(this.overlay.get());
        this.bossBar.progress((float)NumbersUtils.bound(this.progress.get().floatValue(), 0.0, 1.0));
        ArrayList<UUID> newViewers = new ArrayList<UUID>(this.viewers.get());
        this.previousViewers.removeAll(newViewers);
        this.previousViewers.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).forEach(this::hide);
        newViewers.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).forEach(player -> {
            if (this.shouldDisplay.apply((Player)player).booleanValue()) {
                this.show((Player)player);
            } else {
                this.hide((Player)player);
            }
        });
        this.previousViewers = newViewers;
    }

    public void show(Player player) {
        player.showBossBar(this.bossBar);
    }
}

