/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.l10n;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import ru.cwcode.cwutils.l10n.L10nPlatform;
import ru.cwcode.cwutils.l10n.LocalizationRepository;
import ru.cwcode.cwutils.reflection.ReflectionUtils;

public class PluginLocalizationRepository
implements LocalizationRepository {
    private static final String DEFAULT_LOCALE = "en";
    Map<String, Map<String, String>> locales = new HashMap<String, Map<String, String>>();
    Map<String, String> defaultLocale;

    public PluginLocalizationRepository(L10nPlatform l10nPlatform) {
        Set<String> localePropertiesFiles = ReflectionUtils.findMatchingResources(l10nPlatform.getFile(), x -> x.startsWith("locale/") && x.endsWith("/locale.properties"));
        for (String localePropertiesFile : localePropertiesFiles) {
            this.loadLocalePropertyFile(l10nPlatform, localePropertiesFile);
        }
        if (this.locales.isEmpty()) {
            l10nPlatform.getLogger().info("No locale properties files were found.");
        } else {
            l10nPlatform.getLogger().info("Loaded " + this.locales.size() + " locales.");
        }
    }

    private void loadLocalePropertyFile(L10nPlatform l10nPlatform, String localePropertiesFile) {
        Properties properties = new Properties();
        try {
            InputStream localePropertiesStream = l10nPlatform.getResource(localePropertiesFile);
            if (localePropertiesStream == null) {
                l10nPlatform.getLogger().warn("Could not find locale properties file: " + localePropertiesFile);
                return;
            }
            properties.load(new InputStreamReader(localePropertiesStream, StandardCharsets.UTF_8));
            for (String languageCode : properties.stringPropertyNames()) {
                this.loadLocale(l10nPlatform, languageCode, properties.getProperty(languageCode));
            }
        }
        catch (IOException e) {
            l10nPlatform.getLogger().error("Failed to load locale properties file: " + localePropertiesFile);
            e.printStackTrace();
        }
    }

    @Override
    public String getEntry(String locale, String key) {
        Map<String, String> localeMap = this.locales.getOrDefault(locale, this.getDefaultLocale());
        String value = localeMap.get(key);
        if (localeMap == this.getDefaultLocale()) {
            return value;
        }
        if (value == null) {
            return this.getDefaultLocale().get(key);
        }
        return value;
    }

    @Override
    public Set<String> getAvailableLocales() {
        return this.locales.keySet();
    }

    private Map<String, String> getDefaultLocale() {
        if (this.defaultLocale != null) {
            return this.defaultLocale;
        }
        this.defaultLocale = this.locales.get(DEFAULT_LOCALE);
        if (this.defaultLocale == null) {
            this.defaultLocale = this.locales.values().stream().findFirst().orElseGet(() -> Collections.EMPTY_MAP);
        }
        return this.defaultLocale;
    }

    private void loadLocale(L10nPlatform l10nPlatform, String languageCode, String path) {
        InputStream localeStream = l10nPlatform.getResource(path);
        if (localeStream == null) {
            l10nPlatform.getLogger().warn("Cannot find locale `" + languageCode + "` at `" + path + "`");
            return;
        }
        Properties locale = new Properties();
        try {
            locale.load(new InputStreamReader(localeStream, StandardCharsets.UTF_8));
            this.locales.computeIfAbsent(languageCode, k -> new HashMap()).putAll(locale);
            l10nPlatform.getLogger().info("Loaded locale `" + languageCode + "` from `" + path + "`");
        }
        catch (IOException e) {
            l10nPlatform.getLogger().warn("Cannot load locale `" + languageCode + "`: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

