/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.scheduler;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.cwutils.scheduler.AbstractScheduler;
import ru.cwcode.cwutils.scheduler.Tasks;
import ru.cwcode.cwutils.scheduler.VoidScheduler;

public class Scheduler<T>
extends AbstractScheduler {
    private final T anything;
    private volatile Consumer<T> action = x -> {};
    private volatile Consumer<T> lastlyAction = x -> {};
    private volatile Predicate<T> condition = null;

    protected Scheduler(T anything) {
        this.anything = anything;
    }

    public static <T> Scheduler<T> create(T anything) {
        return new Scheduler<T>(anything);
    }

    public static VoidScheduler create() {
        return VoidScheduler.create();
    }

    public Scheduler<T> perform(Consumer<T> action) {
        this.action = action;
        return this;
    }

    public Scheduler<T> until(Predicate<T> condition) {
        this.condition = condition;
        return this;
    }

    public Scheduler<T> async() {
        this.asyncTask = true;
        this.blocked = true;
        return this;
    }

    public Scheduler<T> async(boolean async) {
        this.asyncTask = async;
        this.blocked = async || this.blocked;
        return this;
    }

    public Scheduler<T> infinite() {
        this.infinite = true;
        return this;
    }

    public Scheduler<T> infinite(boolean infinite) {
        this.infinite = infinite;
        return this;
    }

    public Scheduler<T> otherwise(Consumer<T> lastlyAction) {
        this.lastlyAction = lastlyAction;
        return this;
    }

    public BukkitTask registerTask(JavaPlugin plugin, long delay) {
        BukkitTask task = this.asyncTask ? Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, this::tick, delay, delay) : Bukkit.getScheduler().runTaskTimer((Plugin)plugin, this::tick, delay, delay);
        this.registrant = plugin;
        this.taskId = task.getTaskId();
        Tasks.put(this.id, this);
        return task;
    }

    public int register(JavaPlugin plugin, long delay) {
        return this.registerTask(plugin, delay).getTaskId();
    }

    private void tick() {
        if (this.blocked && this.running) {
            return;
        }
        if (this.condition == null) {
            this.runWithCancelling(this.action);
        } else if (this.condition.test(this.anything)) {
            this.run(this.action);
        } else {
            this.runWithCancelling(this.lastlyAction);
        }
    }

    private void runWithCancelling(Consumer<T> action) {
        try {
            this.running = true;
            action.accept(this.anything);
            if (!this.infinite) {
                Tasks.cancelTask(this.id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.running = false;
        }
    }

    private void run(Consumer<T> action) {
        try {
            this.running = true;
            action.accept(this.anything);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.running = false;
        }
    }

    public static void runSync(@NotNull JavaPlugin plugin, @NotNull Runnable runnable) {
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
        } else {
            Bukkit.getScheduler().runTask((Plugin)plugin, runnable);
        }
    }
}

