/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.color;

import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.HSVLike;
import ru.cwcode.commands.color.ColorGenerationStrategy;

public class ColoredScheme
implements ColorGenerationStrategy {
    private final TextColor main;
    private final TextColor argument;
    private final TextColor optional;
    private final TextColor subcommand;
    private final TextColor written;
    private final TextColor permissions;
    private final TextColor accent;
    private final TextColor argumentWithNoPermissions;
    private final TextColor optionalWithNoPermissions;
    private final TextColor subcommandWithNoPermissions;
    private final TextColor writtenWithNoPermissions;
    private final TextColor permissionsWithNoPermissions;
    private final TextColor accentWithNoPermissions;

    public ColoredScheme(TextColor baseColor, TextColor baseNoPermissionColor) {
        this.main = this.generateColor(baseColor, TextColor.fromHexString("#00a6f0"));
        this.argument = this.generateColor(baseColor, TextColor.fromHexString("#00baff"));
        this.optional = this.generateColor(baseColor, TextColor.fromHexString("#02d7ff"));
        this.subcommand = this.generateColor(baseColor, TextColor.fromHexString("#0098dc"));
        this.written = this.generateColor(baseColor, TextColor.fromHexString("#007ab5"));
        this.permissions = this.generateColor(baseColor, TextColor.fromHexString("#055080"));
        this.accent = this.generateColor(baseColor, TextColor.fromHexString("#8adaff"));
        this.argumentWithNoPermissions = this.generateColor(baseNoPermissionColor, TextColor.fromHexString("#FF2C00"));
        this.optionalWithNoPermissions = this.generateColor(baseNoPermissionColor, TextColor.fromHexString("#FF1800"));
        this.subcommandWithNoPermissions = this.generateColor(baseNoPermissionColor, TextColor.fromHexString("#FF2C00"));
        this.writtenWithNoPermissions = this.generateColor(baseNoPermissionColor, TextColor.fromHexString("#FF3100"));
        this.permissionsWithNoPermissions = this.generateColor(baseNoPermissionColor, TextColor.fromHexString("#C83000"));
        this.accentWithNoPermissions = this.generateColor(baseNoPermissionColor, TextColor.fromHexString("#FF9C84"));
    }

    public ColoredScheme(TextColor baseColor) {
        this(baseColor, baseColor);
    }

    private TextColor generateColor(TextColor h, TextColor sv) {
        HSVLike hsvH = h.asHSV();
        HSVLike hsvSV = sv.asHSV();
        HSVLike combined = HSVLike.of(hsvH.h(), hsvSV.s(), hsvSV.v());
        return TextColor.color(combined);
    }

    @Override
    public TextColor main() {
        return this.main;
    }

    @Override
    public TextColor argument(boolean canPerformedBy) {
        return canPerformedBy ? this.argument : this.argumentWithNoPermissions;
    }

    @Override
    public TextColor optional(boolean canPerformedBy) {
        return canPerformedBy ? this.optional : this.optionalWithNoPermissions;
    }

    @Override
    public TextColor subcommand(boolean canPerformedBy) {
        return canPerformedBy ? this.subcommand : this.subcommandWithNoPermissions;
    }

    @Override
    public TextColor written(boolean canPerformedBy) {
        return canPerformedBy ? this.written : this.writtenWithNoPermissions;
    }

    @Override
    public TextColor permissions(boolean canPerformedBy) {
        return canPerformedBy ? this.permissions : this.permissionsWithNoPermissions;
    }

    @Override
    public TextColor accent(boolean canPerformedBy) {
        return canPerformedBy ? this.accent : this.accentWithNoPermissions;
    }
}

