/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.velocityplatform.argument;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.ArrayList;
import java.util.List;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.velocityplatform.VelocityMain;
import ru.cwcode.commands.velocityplatform.velocity.VelocitySender;

public class OnlinePlayerWithPermissionArg
extends Argument {
    String permission;
    String argumentName = null;

    public OnlinePlayerWithPermissionArg(String permission) {
        this.permission = permission;
    }

    public OnlinePlayerWithPermissionArg(String permission, String argumentName) {
        this.permission = permission;
        this.argumentName = permission;
    }

    @Override
    public boolean valid(String raw) {
        Player player = VelocityMain.getPlatform().getServer().getPlayer(raw).orElse(null);
        return player != null && player.hasPermission(this.permission);
    }

    public List<String> completions(Sender sender) {
        VelocitySender velocitySender;
        ServerConnection server;
        ArrayList<String> list = new ArrayList<String>();
        if (sender.isPlayer() && sender instanceof VelocitySender && (server = (ServerConnection)(velocitySender = (VelocitySender)sender).getPlayer().getCurrentServer().orElse(null)) != null) {
            for (Player player : server.getServer().getPlayersConnected()) {
                if (!player.hasPermission(this.permission)) continue;
                list.add(player.getUsername());
            }
        }
        return list;
    }

    @Override
    public String argumentName() {
        return this.argumentName == null ? CommandsAPI.l10n.get("argument.onlinePlayerWithPermission.name", this.permission) : this.argumentName;
    }

    @Override
    public Object map() {
        return VelocityMain.getPlatform().getServer().getPlayer(this.raw);
    }
}

