/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.bounceable;

import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.cwcode.cwutils.bounceable.Bounceable;

public class BounceableListener
implements Listener {
    private static boolean isRegistered = false;
    private static final Map<Entity, Bounceable<? extends Entity, ? extends EntityEvent>> bouncedEntities = new WeakHashMap<Entity, Bounceable<? extends Entity, ? extends EntityEvent>>();
    private static JavaPlugin plugin;

    private BounceableListener() {
    }

    @EventHandler
    void onChange(EntityChangeBlockEvent event) {
        Entity entity = event.getEntity();
        if (entity.getType() != EntityType.FALLING_BLOCK) {
            return;
        }
        Bounceable<? extends Entity, ? extends EntityEvent> bounceable = bouncedEntities.remove(entity);
        if (bounceable == null) {
            return;
        }
        bounceable.onExecute((EntityEvent)event);
    }

    @EventHandler
    void onEntityRemove(EntityRemoveFromWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity.getType() != EntityType.FALLING_BLOCK) {
            return;
        }
        Bounceable<? extends Entity, ? extends EntityEvent> bounceable = bouncedEntities.remove(entity);
        if (bounceable == null) {
            return;
        }
        Location location = event.getEntity().getLocation().toCenterLocation();
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> location.getNearbyEntitiesByType(Item.class, 1.0).forEach(Entity::remove), 1L);
    }

    @EventHandler
    void onExplode(EntityExplodeEvent event) {
        Entity entity = event.getEntity();
        if (entity.getType() != EntityType.PRIMED_TNT) {
            return;
        }
        Bounceable<? extends Entity, ? extends EntityEvent> bounceable = bouncedEntities.remove(entity);
        if (bounceable == null) {
            return;
        }
        bounceable.onExecute((EntityEvent)event);
    }

    public static void addBouncedEntity(Entity entity, Bounceable<? extends Entity, ? extends EntityEvent> bounceable) {
        if (!isRegistered) {
            return;
        }
        bouncedEntities.put(entity, bounceable);
    }

    public static void register(JavaPlugin plugin) {
        if (isRegistered) {
            return;
        }
        isRegistered = true;
        BounceableListener.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)new BounceableListener(), (Plugin)plugin);
    }
}

