/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.asm;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import revxrsal.asm.MethodCaller;
import revxrsal.asm.define.Definer;

final class MethodCallerFactory {
    private static final AtomicInteger IDS = new AtomicInteger();
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final String OBJECT = OBJECT_TYPE.getInternalName();
    private static final String[] INTERFACES = new String[]{Type.getInternalName(MethodCaller.class)};
    private static final Method CONSTRUCTOR = new Method("<init>", "()V");
    private static final Method INVOKE = new Method("call", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
    private static final List<String> STRIPPED_CLASS_NAMES = Arrays.asList(MethodCallerFactory.class.getName(), MethodCaller.class.getName());

    private MethodCallerFactory() {
    }

    public static MethodCaller createFor(@NotNull java.lang.reflect.Method method) {
        return MethodCallerFactory.createFor(method, method.getDeclaringClass().getClassLoader());
    }

    public static MethodCaller createFor(@NotNull java.lang.reflect.Method method, @NotNull ClassLoader loader) {
        Objects.requireNonNull(method, "method cannot be null!");
        Objects.requireNonNull(loader, "class loader cannot be null!");
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        if (Modifier.isPrivate(method.getModifiers()) || Definer.isPackagePrivate(method) && !Definer.supportsPackagePrivate()) {
            return MethodCallerFactory.getReflectionCaller(method, isStatic);
        }
        ClassWriter writer = new ClassWriter(2);
        String internalClassName = MethodCallerFactory.getCallerName(method);
        String className = internalClassName.replace('/', '.');
        Type declaringClass = Type.getType(method.getDeclaringClass());
        writer.visit(52, 17, internalClassName, null, OBJECT, INTERFACES);
        GeneratorAdapter gen = new GeneratorAdapter(1, CONSTRUCTOR, null, null, writer);
        gen.loadThis();
        gen.invokeConstructor(OBJECT_TYPE, CONSTRUCTOR);
        gen.returnValue();
        gen.endMethod();
        gen = new GeneratorAdapter(1, INVOKE, null, null, writer);
        if (!isStatic) {
            gen.loadArg(0);
            gen.checkCast(declaringClass);
        }
        int index = 0;
        for (Parameter parameter : method.getParameters()) {
            gen.loadArg(1);
            gen.push(index++);
            gen.arrayLoad(OBJECT_TYPE);
            if (parameter.getType().isPrimitive()) {
                gen.unbox(Type.getType(parameter.getType()));
                continue;
            }
            gen.checkCast(Type.getType(parameter.getType()));
        }
        if (isStatic) {
            gen.invokeStatic(declaringClass, Method.getMethod(method));
        } else {
            gen.invokeVirtual(declaringClass, Method.getMethod(method));
        }
        if (method.getReturnType() == Void.TYPE) {
            gen.push((String)null);
        } else if (method.getReturnType().isPrimitive()) {
            gen.box(Type.getType(method.getReturnType()));
        }
        gen.returnValue();
        gen.endMethod();
        writer.visitEnd();
        byte[] bytes = writer.toByteArray();
        try {
            MethodCaller caller = Definer.defineClass(loader, className, bytes).asSubclass(MethodCaller.class).newInstance();
            int paramCount = method.getParameterCount();
            return MethodCallerFactory.wrap(isStatic, paramCount, className, caller);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    private static MethodCaller getReflectionCaller(@NotNull java.lang.reflect.Method method, boolean isStatic) {
        try {
            method.setAccessible(true);
            MethodHandle handle = MethodHandles.lookup().unreflect(method);
            return MethodCallerFactory.wrap(isStatic, method.getParameterCount(), null, (instance, arguments) -> {
                try {
                    ArrayList<Object> argumentsList = new ArrayList<Object>();
                    if (!isStatic) {
                        argumentsList.add(instance);
                    }
                    Collections.addAll(argumentsList, arguments);
                    return handle.invokeWithArguments(argumentsList);
                }
                catch (InvocationTargetException e) {
                    MethodCallerFactory.sneakyThrow(e.getCause());
                    return null;
                }
                catch (Throwable e) {
                    MethodCallerFactory.sneakyThrow(e);
                    return null;
                }
            });
        }
        catch (Exception e) {
            MethodCallerFactory.sneakyThrow(e);
            return null;
        }
    }

    private static MethodCaller wrap(boolean isStatic, int paramCount, String className, MethodCaller caller) {
        return (instance, arguments) -> {
            try {
                if (instance == null && !isStatic) {
                    throw new IllegalStateException("This method is not static, and no instance was provided!");
                }
                if (arguments.length != paramCount) {
                    throw new IllegalStateException("Invalid argument type: " + arguments.length + ". Expected " + paramCount);
                }
                return caller.call(instance, arguments);
            }
            catch (Throwable throwable) {
                MethodCallerFactory.sanitizeStackTrace(className, throwable);
                MethodCallerFactory.sneakyThrow(throwable);
                return null;
            }
        };
    }

    private static void sanitizeStackTrace(@Nullable String className, @NotNull Throwable throwable) {
        if (throwable.getCause() != null) {
            MethodCallerFactory.sanitizeStackTrace(className, throwable.getCause());
        }
        ArrayList<StackTraceElement> trace = new ArrayList<StackTraceElement>();
        Collections.addAll(trace, throwable.getStackTrace());
        trace.removeIf(element -> element.getClassName().equals(className) || STRIPPED_CLASS_NAMES.contains(element.getClassName()));
        throwable.setStackTrace(trace.toArray(new StackTraceElement[0]));
    }

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    @NotNull
    private static String getCallerName(@NotNull java.lang.reflect.Method method) {
        return (method.getDeclaringClass().getName() + "MethodCaller" + IDS.getAndIncrement()).replace('.', '/');
    }
}

