/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.executor;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import revxrsal.asm.BoundMethodCaller;
import revxrsal.asm.MethodCaller;
import ru.cwcode.commands.Argument;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.arguments.ExactStringArg;
import ru.cwcode.commands.executor.AbstractExecutor;
import ru.cwcode.cwutils.collections.CollectionUtils;
import ru.cwcode.cwutils.messages.MessageReturn;

public abstract class AbstractAutowiredExecutor
extends AbstractExecutor {
    private final MethodTypeNode rootNode = new MethodTypeNode();

    public AbstractAutowiredExecutor() {
        for (Method declaredMethod : this.getClass().getDeclaredMethods()) {
            this.rootNode.register(declaredMethod, this);
        }
    }

    @Override
    public void executeForPlayer() {
        Argument[] args = this.parser.args;
        int argsLength = args.length;
        Object[] mapped = new Object[argsLength];
        Class[] mappedTypes = new Class[argsLength];
        int mappedParametersCount = 0;
        for (Argument arg : args) {
            Object map;
            if (arg instanceof ExactStringArg) continue;
            mapped[mappedParametersCount] = map = arg.map();
            mappedTypes[mappedParametersCount] = map.getClass();
            ++mappedParametersCount;
        }
        BoundMethodCaller foundedMethod = this.rootNode.find(mappedTypes, mappedParametersCount);
        if (foundedMethod == null) {
            throw new MessageReturn(CommandsAPI.l10n.get("error.noSuchMethod", CollectionUtils.toString(Arrays.stream(mappedTypes).map(Class::getSimpleName).collect(Collectors.toList()))));
        }
        try {
            foundedMethod.call(Arrays.copyOf(mapped, mappedParametersCount));
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                this.handleError((Exception)cause);
                return;
            }
            this.handleError(e);
        }
    }

    private static class MethodTypeNode {
        private BoundMethodCaller method;
        private final Map<Class<?>, MethodTypeNode> children = new HashMap();

        private MethodTypeNode() {
        }

        public void register(Method method, Object bindTo) {
            this.register(method.getParameterTypes(), MethodCaller.wrap(method).bindTo(bindTo), 0);
        }

        private void register(Class<?>[] parameterTypes, BoundMethodCaller method, int level) {
            if (level == parameterTypes.length) {
                this.method = method;
                return;
            }
            this.children.computeIfAbsent(parameterTypes[level], __ -> new MethodTypeNode()).register(parameterTypes, method, level + 1);
        }

        public BoundMethodCaller find(Class<?>[] parameterTypes, int depth) {
            return this.find(parameterTypes, 0, depth);
        }

        private BoundMethodCaller find(Class<?>[] parameterTypes, int level, int depth) {
            if (level == depth) {
                return this.method;
            }
            for (Map.Entry<Class<?>, MethodTypeNode> entry : this.children.entrySet()) {
                BoundMethodCaller result;
                if (!entry.getKey().isAssignableFrom(parameterTypes[level]) || (result = entry.getValue().find(parameterTypes, level + 1, depth)) == null) continue;
                return result;
            }
            return null;
        }
    }
}

