/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.extra.builder.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.StyleSetter;
import ru.cwcode.commands.ArgumentParser;
import ru.cwcode.commands.ArgumentSet;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.arguments.ExactStringArg;
import ru.cwcode.commands.arguments.basic.StringArg;
import ru.cwcode.commands.extra.RepositoryAccessor;
import ru.cwcode.commands.extra.builder.CommandBuilder;
import ru.cwcode.commands.extra.builder.list.ListContext;
import ru.cwcode.commands.extra.builder.list.ListDecorator;
import ru.cwcode.commands.extra.builder.list.ListField;
import ru.cwcode.commands.extra.command.argument.PageArgument;
import ru.cwcode.commands.extra.command.executor.ExtraExecutor;
import ru.cwcode.commands.extra.command.executor.SimpleExecutor;
import ru.cwcode.commands.preconditions.impl.HiddenCommandPrecondition;

public class ListCommandBuilder<E, K, S extends Sender>
extends CommandBuilder<E, K, S> {
    List<ListField<E, S>> fields = new ArrayList<ListField<E, S>>();
    int pageSize = 10;
    Component separator = Component.text(" ");
    ListDecorator<S> listDecorator = new ListDecorator();
    String name = "list";
    Command command;
    boolean showIndex = false;
    Consumer<ArgumentSet> argumentSetConsumer = __ -> {};

    public ListCommandBuilder(RepositoryAccessor<E, K, S> builder) {
        super(builder);
    }

    public ListCommandBuilder<E, K, S> argumentSetEdit(Consumer<ArgumentSet> argumentSet) {
        this.argumentSetConsumer = argumentSet;
        return this;
    }

    public ListCommandBuilder<E, K, S> showIndex(boolean showIndex) {
        this.showIndex = showIndex;
        return this;
    }

    public ListCommandBuilder<E, K, S> field(Consumer<ListField<E, S>> fieldConsumer) {
        ListField field = new ListField();
        fieldConsumer.accept(field);
        this.fields.add(field);
        return this;
    }

    public ListCommandBuilder<E, K, S> decorate(Consumer<ListDecorator<S>> listDecorator) {
        listDecorator.accept(this.listDecorator);
        return this;
    }

    public ListCommandBuilder<E, K, S> separator(Component separator) {
        this.separator = separator;
        return this;
    }

    public ListCommandBuilder<E, K, S> name(String name) {
        this.name = name;
        return this;
    }

    public ListCommandBuilder<E, K, S> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public void register(Command command) {
        this.command = command;
        ArgumentSet clickHandler = new ArgumentSet(new ExtraExecutor(this.repositoryAccessor, this::click, 1), new ExactStringArg("handleClick"), this.repositoryAccessor.keyArgument(), new StringArg()).hidden().preconditions(new HiddenCommandPrecondition());
        ArgumentSet list = new ArgumentSet(new SimpleExecutor<Sender>(this::showList), new ExactStringArg(this.name), new PageArgument(this.repositoryAccessor).optional());
        this.argumentSetConsumer.accept(clickHandler);
        this.argumentSetConsumer.accept(list);
        command.arguments(clickHandler, list);
    }

    private void click(S sender, E element, ArgumentParser argumentParser) {
        String field = argumentParser.get(2).toString();
        for (ListField<E, S> listField : this.fields) {
            if (!listField.name.equals(field)) continue;
            listField.onClick.accept(element, sender);
            return;
        }
    }

    private void showList(S sender, ArgumentParser argumentParser) {
        Component footer;
        Component noElementsMessage;
        int page = argumentParser.isPresent(1) ? argumentParser.get(1).toInt() : 1;
        int skip = (page - 1) * this.pageSize;
        int limit = this.pageSize;
        int currentIndex = 0;
        Collection keys = this.repositoryAccessor.keys(sender);
        ListContext listContext = new ListContext(this.command, page, (int)Math.ceil((double)keys.size() / (double)this.pageSize));
        Component header = this.listDecorator.header.apply(listContext, sender);
        if (header != null) {
            sender.sendMessage(header);
        }
        for (Object key : keys) {
            ++currentIndex;
            if (skip > 0) {
                --skip;
                continue;
            }
            if (limit == 0) break;
            --limit;
            Object element = this.repositoryAccessor.keyToElement(sender, key);
            Component row = Component.empty();
            if (this.showIndex) {
                row = row.append(this.listDecorator.indexField.apply(listContext, currentIndex, sender));
            }
            for (ListField<E, S> field : this.fields) {
                if (!field.shouldShow.apply(element, sender).booleanValue()) continue;
                StyleSetter<Component> text = field.text.apply(element, sender);
                Component hover = field.hover == null ? null : field.hover.apply(element, sender);
                BiConsumer onClick = field.onClick;
                if (hover != null) {
                    text = text.hoverEvent(HoverEvent.showText(hover));
                }
                if (onClick != null) {
                    String commandStr = String.format("/%s handleClick %s %s", this.command.getFullCommandPath(this.command.getRootCommand().getName()), this.repositoryAccessor.keyToString(key), field.name);
                    text = text.clickEvent(ClickEvent.runCommand(commandStr));
                }
                if (!row.equals(Component.empty())) {
                    row = row.append(this.separator);
                }
                row = row.append((Component)text);
            }
            sender.sendMessage(row);
        }
        if (limit == this.pageSize && (noElementsMessage = this.listDecorator.noElements.apply(listContext, sender)) != null) {
            sender.sendMessage(noElementsMessage);
        }
        if ((footer = this.listDecorator.footer.apply(listContext, sender)) != null) {
            sender.sendMessage(footer);
        }
    }
}

