/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.velocityplatform.velocity;

import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.proxy.ProxyServer;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.api.CommandsAPI;
import ru.cwcode.commands.api.Platform;
import ru.cwcode.commands.api.Sender;
import ru.cwcode.commands.velocityplatform.VelocityMain;
import ru.cwcode.commands.velocityplatform.velocity.VelocityCommand;
import ru.cwcode.cwutils.logger.VelocityLogger;
import ru.cwcode.cwutils.messages.MessageReturn;

public class VelocityPlatform
extends Platform {
    private final VelocityMain plugin;
    private final ProxyServer server;
    private final ru.cwcode.cwutils.logger.Logger logger;

    public VelocityPlatform(VelocityMain plugin, ProxyServer server, Logger logger) {
        this.plugin = plugin;
        this.server = server;
        this.logger = new VelocityLogger(logger);
    }

    public VelocityMain getPlugin() {
        return this.plugin;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    @Override
    public ru.cwcode.cwutils.logger.Logger getLogger() {
        return this.logger;
    }

    @Override
    public void registerCommand(Command command) {
        try {
            CommandManager commandManager = this.server.getCommandManager();
            commandManager.register(commandManager.metaBuilder(command.getName()).aliases(command.aliases().toArray(new String[0])).plugin((Object)this.plugin).build(), (com.velocitypowered.api.command.Command)new VelocityCommand(command));
        }
        catch (Exception e) {
            this.logger.warn(CommandsAPI.l10n.get("velocityPlatform.commandIsNotRegistered", command.getName()));
        }
    }

    @Override
    public void handleExecutionException(Exception exception, Command command, Sender sender) {
        if (exception instanceof MessageReturn) {
            MessageReturn messageReturn = (MessageReturn)exception;
            if (messageReturn.isStyled()) {
                sender.sendMessage(messageReturn.getComponentMessage());
            } else {
                sender.sendMessage(messageReturn.getComponentMessage().color(command.getColorScheme().main()));
            }
            return;
        }
        String localizedMessage = exception.getLocalizedMessage();
        if (localizedMessage == null) {
            localizedMessage = CommandsAPI.l10n.get("velocityPlatform.unknownError", new Object[0]);
        }
        sender.sendMessage(Component.text(localizedMessage, command.getColorScheme().main()));
        CommandsAPI.getPlatform().getLogger().warn(CommandsAPI.l10n.get("velocityPlatform.executionError", this.getClass().getName()));
        exception.printStackTrace();
    }
}

