/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.items;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemTypes {
    static final HashMap<Material, ItemType> mappedTypes = new HashMap();
    static final HashMap<Material, Instruments> mappedInstruments = new HashMap();

    public static ItemType getItemType(ItemStack item) {
        return item == null ? ItemType.NONE : ItemTypes.getItemType(item.getType());
    }

    public static Instruments getToolType(ItemStack item) {
        return item == null ? Instruments.NONE : ItemTypes.getToolType(item.getType());
    }

    public static ItemType getItemType(Material itemType) {
        return itemType == null ? ItemType.NONE : mappedTypes.getOrDefault(itemType, ItemType.NONE);
    }

    public static Instruments getToolType(Material itemType) {
        return itemType == null ? Instruments.NONE : mappedInstruments.getOrDefault(itemType, Instruments.NONE);
    }

    public static boolean isSword(ItemStack item) {
        return item != null && Instruments.SWORD.contains(item.getType());
    }

    public static boolean isAxe(ItemStack item) {
        return item != null && Instruments.AXE.contains(item.getType());
    }

    public static boolean isHoe(ItemStack item) {
        return item != null && Instruments.HOE.contains(item.getType());
    }

    public static boolean isShovel(ItemStack item) {
        return item != null && Instruments.SHOVEL.contains(item.getType());
    }

    public static boolean isPickaxe(ItemStack item) {
        return item != null && Instruments.PICKAXE.contains(item.getType());
    }

    public static boolean isTool(ItemStack item) {
        return item != null && mappedInstruments.containsKey(item.getType());
    }

    public static boolean isTrident(ItemStack item) {
        return item != null && item.getType() == Material.TRIDENT;
    }

    public static boolean isUsable(ItemStack item) {
        return item != null && ItemTypes.isUsable(item.getType());
    }

    public static boolean isUsable(Material material) {
        switch (material) {
            case POTION: 
            case LINGERING_POTION: 
            case SPLASH_POTION: 
            case WRITABLE_BOOK: 
            case WRITTEN_BOOK: 
            case ENDER_EYE: 
            case ENDER_PEARL: 
            case BOW: 
            case CROSSBOW: {
                return true;
            }
        }
        return material.isEdible();
    }

    public static enum ItemType {
        NONE(false),
        WOODEN(true),
        STONE(true),
        LEATHER(true),
        CHAINMAIL(true),
        GOLDEN(true),
        IRON(true),
        DIAMOND(true),
        NETHERITE(true);


        private ItemType(boolean shouldTryToFoundItems) {
            if (!shouldTryToFoundItems) {
                return;
            }
            Arrays.stream(Material.values()).filter(x -> x.name().startsWith(this.name() + "_")).forEach(x -> mappedTypes.put((Material)x, this));
        }
    }

    public static enum Instruments {
        NONE(false),
        SWORD(true),
        HOE(true),
        PICKAXE(true),
        SHOVEL(true),
        AXE(true);

        final Set<Material> values = new HashSet<Material>();

        private Instruments(boolean shouldTryToFoundItems) {
            if (!shouldTryToFoundItems) {
                return;
            }
            Arrays.stream(Material.values()).filter(x -> x.name().endsWith("_" + this.name())).forEach(e -> {
                this.values.add((Material)e);
                mappedInstruments.put((Material)e, this);
            });
        }

        public boolean contains(Material type) {
            return this.values.contains(type);
        }
    }
}

