/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.worldEdit;

import com.google.common.io.Files;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class WorldEditUtils {
    static Logger log = Logger.getLogger("WorldEditUtils");

    public static BlockVector3 pasteClipboard(Location loc, Clipboard clipboard, boolean ignoreAirBlocks) {
        try (EditSession editSession = WorldEdit.getInstance().newEditSession(BukkitAdapter.adapt((World)loc.getWorld()));){
            ClipboardHolder holder = new ClipboardHolder(clipboard);
            Operation operation = holder.createPaste((Extent)editSession).ignoreAirBlocks(ignoreAirBlocks).to(BukkitAdapter.adapt((Location)loc).toVector().toBlockPoint()).build();
            Operations.complete((Operation)operation);
        }
        catch (WorldEditException e) {
            e.printStackTrace();
            return null;
        }
        return clipboard.getDimensions();
    }

    public static Clipboard saveSelection(Player player, Path path) {
        try {
            WorldEditPlugin worldEditPlugin = (WorldEditPlugin)Bukkit.getServer().getPluginManager().getPlugin("WorldEdit");
            Region selection = worldEditPlugin.getSession(player).getSelection(BukkitAdapter.adapt((World)player.getWorld()));
            return WorldEditUtils.saveRegion(player.getWorld(), selection, path);
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
    }

    public static Clipboard saveRegion(World world, Region region, Path path) {
        try {
            BlockArrayClipboard clipboard = new BlockArrayClipboard(region);
            clipboard.setOrigin(BlockVector3.at((int)clipboard.getMinimumPoint().getX(), (int)clipboard.getMinimumPoint().getY(), (int)clipboard.getMinimumPoint().getZ()));
            try (EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(BukkitAdapter.adapt((World)world), -1);){
                ForwardExtentCopy forwardExtentCopy = new ForwardExtentCopy((Extent)editSession, region, (Extent)clipboard, region.getMinimumPoint());
                Operations.complete((Operation)forwardExtentCopy);
            }
            catch (WorldEditException e) {
                e.printStackTrace();
            }
            File file = path.toFile();
            Files.createParentDirs((File)file);
            try (ClipboardWriter writer = BuiltInClipboardFormat.SPONGE_SCHEMATIC.getWriter((OutputStream)new FileOutputStream(file));){
                writer.write((Clipboard)clipboard);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            return clipboard;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Clipboard loadSchematic(Path path) {
        Clipboard clipboard;
        File file = path.toFile();
        ClipboardFormat format = ClipboardFormats.findByFile((File)file);
        try (ClipboardReader reader = format.getReader((InputStream)new FileInputStream(file));){
            clipboard = reader.read();
        }
        catch (Exception e) {
            log.warning("\u041d\u0435 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0447\u0435\u0441\u0442\u044c \u0441\u0445\u0435\u043c\u0430\u0442\u0438\u043a\u0443 " + path);
            return null;
        }
        clipboard.setOrigin(clipboard.getMinimumPoint());
        return clipboard;
    }
}

