/*
 * Decompiled with CFR 0.152.
 */
package com.saicone.rtag.util;

import com.saicone.rtag.Rtag;
import com.saicone.rtag.tag.TagBase;
import com.saicone.rtag.tag.TagCompound;
import com.saicone.rtag.tag.TagList;
import com.saicone.rtag.util.EasyLookup;
import com.saicone.rtag.util.OptionalType;
import com.saicone.rtag.util.ServerInstance;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class ChatComponent {
    public static final String[] NBT_PALETTE = new String[]{"\u00a7f", "\u00a7b", "\u00a7a", "\u00a76", "\u00a7c"};
    public static final String[] NBT_PALETTE_HEX = new String[]{"\u00a7#FCFCFC", "\u00a7#55E3FF", "\u00a7#55FF71", "\u00a7#FFD500", "\u00a7#FF7155"};
    public static final String[] NBT_PALETTE_BUNGEE = new String[]{"\u00a7x\u00a7F\u00a7C\u00a7F\u00a7C\u00a7F\u00a7C", "\u00a7x\u00a75\u00a75\u00a7E\u00a73\u00a7F\u00a7F", "\u00a7x\u00a75\u00a75\u00a7F\u00a7F\u00a77\u00a71", "\u00a7x\u00a7F\u00a7F\u00a7D\u00a75\u00a70\u00a70", "\u00a7x\u00a7F\u00a7F\u00a77\u00a71\u00a75\u00a75"};
    public static final String[] NBT_PALETTE_MINIMESSAGE = new String[]{"<white>", "<aqua>", "<green>", "<gold>", "<red>"};
    private static final Class<?> CHAT_BASE_COMPONENT;
    private static final char[] RAW_SUFFIX;
    private static final MethodHandle fromString;
    private static final MethodHandle fromComponent;
    private static final MethodHandle fromJson;
    private static final MethodHandle toJson;

    ChatComponent() {
    }

    public static boolean isChatComponent(Object object) {
        if (object instanceof String) {
            String s = (String)object;
            if (s.length() > 11) {
                int index;
                if (s.charAt(0) == '{' && s.charAt(s.length() - 1) == '}' && (index = s.indexOf("\"text\":\"")) > 0) {
                    char c;
                    int i = s.indexOf(34, index + 8) + 1;
                    return i + 1 >= s.length() || (c = s.charAt(i)) == '}' || c == ',';
                }
            } else if (s.length() == 11) {
                return s.equals("{\"text\":\"\"}");
            }
            return false;
        }
        return CHAT_BASE_COMPONENT.isInstance(object);
    }

    public static Object fromJson(String json) {
        try {
            if (json == null || json.isEmpty()) {
                return null;
            }
            if (ServerInstance.Release.COMPONENT) {
                return fromJson.invoke(json, Rtag.getMinecraftRegistry());
            }
            return fromJson.invoke(json);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object fromString(String string) {
        try {
            if (ServerInstance.MAJOR_VERSION >= 13) {
                return fromString.invoke(string);
            }
            return string == null || string.isEmpty() ? null : fromString.invoke(string)[0];
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static String toJson(Object component) throws IllegalArgumentException {
        if (component instanceof String) {
            Object o = ChatComponent.fromString((String)component);
            if (o == null) {
                return "{\"text\":\"\"}";
            }
            return ChatComponent.toJson(o);
        }
        Objects.requireNonNull(component, "The provided object cannot be null");
        if (!CHAT_BASE_COMPONENT.isInstance(component)) {
            throw new IllegalArgumentException("The provided object isn't an IChatBaseComponent");
        }
        try {
            if (ServerInstance.Release.COMPONENT) {
                return toJson.invoke(component, Rtag.getMinecraftRegistry());
            }
            return toJson.invoke(component);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static String toJsonOrNull(Object component) throws IllegalArgumentException {
        if (component instanceof String) {
            return ChatComponent.toJsonOrNull(ChatComponent.fromString((String)component));
        }
        return component == null ? null : ChatComponent.toJson(component);
    }

    public static String toString(Object component) throws IllegalArgumentException {
        if (component instanceof String) {
            Object o = ChatComponent.fromJson((String)component);
            if (o == null) {
                return "";
            }
            return ChatComponent.toString(o);
        }
        Objects.requireNonNull(component, "The provided object cannot be null");
        if (!CHAT_BASE_COMPONENT.isInstance(component)) {
            throw new IllegalArgumentException("The provided object isn't an IChatBaseComponent");
        }
        try {
            return fromComponent.invoke(component);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static String toStringOrNull(Object component) throws IllegalArgumentException {
        if (component instanceof String) {
            return ChatComponent.toStringOrNull(ChatComponent.fromJson((String)component));
        }
        return component == null ? null : ChatComponent.toString(component);
    }

    public static Object toPrettyComponent(Object tag, String indent) {
        return ChatComponent.toPrettyComponent(tag, indent, NBT_PALETTE);
    }

    public static Object toPrettyComponent(Object tag, String indent, String[] palette) {
        return ChatComponent.fromString(ChatComponent.toPrettyString(tag, indent, palette));
    }

    public static String toPrettyJson(Object tag, String indent) {
        return ChatComponent.toPrettyJson(tag, indent, NBT_PALETTE);
    }

    public static String toPrettyJson(Object tag, String indent, String[] palette) {
        return ChatComponent.toJson(ChatComponent.toPrettyString(tag, indent, palette));
    }

    public static String toPrettyString(Object tag, String indent) {
        return ChatComponent.toPrettyString(tag, indent, NBT_PALETTE);
    }

    public static String toPrettyString(Object tag, String indent, String[] palette) {
        return ChatComponent.pretty(tag, 0, indent == null ? "" : indent, palette);
    }

    private static String pretty(Object tag, int count, String indent, String[] palette) {
        byte id = TagBase.getTypeId(tag);
        if (id < 1 || id > 12) {
            return palette[4] + "null";
        }
        if (id <= 6) {
            return palette[3] + TagBase.getValue(tag) + palette[4] + RAW_SUFFIX[id];
        }
        switch (id) {
            case 7: 
            case 11: 
            case 12: {
                Object suffix = palette[4] + RAW_SUFFIX[id];
                StringJoiner joiner = new StringJoiner(palette[0] + ", ", palette[0] + "[" + (String)suffix + palette[0] + "; ", palette[0] + "]");
                if (id == 11) {
                    suffix = "";
                }
                for (Object o : OptionalType.of(TagBase.getValue(tag))) {
                    joiner.add(palette[3] + o + (String)suffix);
                }
                return joiner.toString();
            }
            case 8: {
                return palette[0] + "\"" + palette[2] + TagBase.getValue(tag) + palette[0] + "\"";
            }
            case 9: {
                return ChatComponent.prettyList(tag, count, indent, palette);
            }
        }
        return ChatComponent.prettyCompound(tag, count, indent, palette);
    }

    private static String prettyList(Object tag, int count, String indent, String[] palette) {
        StringJoiner joiner;
        byte listId;
        List<Object> list = TagList.getValue(tag);
        if (list.isEmpty()) {
            return palette[0] + "[]";
        }
        if (indent.isEmpty() || list.size() <= 8 && (listId = TagList.getType(tag)) >= 1 && listId <= 6) {
            joiner = new StringJoiner(palette[0] + ", ", palette[0] + "[", palette[0] + "]");
        } else {
            String s = indent.repeat(count + 1);
            joiner = new StringJoiner(palette[0] + ",\n" + s, palette[0] + "[\n" + s, palette[0] + "\n" + indent.repeat(count) + "]");
        }
        for (Object o : list) {
            joiner.add(ChatComponent.pretty(o, count + 1, indent, palette));
        }
        return joiner.toString();
    }

    private static String prettyCompound(Object tag, int count, String indent, String[] palette) {
        StringJoiner joiner;
        Map<String, Object> map = TagCompound.getValue(tag);
        if (map.isEmpty()) {
            return palette[0] + "{}";
        }
        if (indent.isEmpty()) {
            joiner = new StringJoiner(palette[0] + ", ", palette[0] + "{", palette[0] + "}");
        } else {
            String s = indent.repeat(count + 1);
            joiner = new StringJoiner(palette[0] + ",\n" + s, palette[0] + "{\n" + s, palette[0] + "\n" + indent.repeat(count) + "}");
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            joiner.add(palette[1] + entry.getKey() + palette[0] + ": " + ChatComponent.pretty(entry.getValue(), count + 1, indent, palette));
        }
        return joiner.toString();
    }

    static {
        RAW_SUFFIX = new char[]{'\u0000', 'b', 's', '\u0000', 'L', 'f', 'd', 'B', '\u0000', '\u0000', '\u0000', 'I', 'L'};
        MethodHandle method$fromString = null;
        MethodHandle method$fromComponent = null;
        MethodHandle method$fromJson = null;
        MethodHandle method$toJson = null;
        try {
            Class<?> clazz = EasyLookup.addNMSClass("network.chat.IChatBaseComponent", "Component");
            EasyLookup.addClassId("ChatSerializer", clazz.getDeclaredClasses()[0]);
            EasyLookup.addOBCClass("util.CraftChatMessage");
            String fromJson = "a";
            String toJson = "a";
            if (ServerInstance.Type.MOJANG_MAPPED) {
                fromJson = "fromJson";
                toJson = "toJson";
            }
            method$fromString = ServerInstance.MAJOR_VERSION >= 13 ? EasyLookup.staticMethod("CraftChatMessage", "fromStringOrNull", "IChatBaseComponent", String.class) : EasyLookup.unreflectMethod("CraftChatMessage", "fromString", String.class);
            method$fromComponent = EasyLookup.staticMethod("CraftChatMessage", "fromComponent", String.class, "IChatBaseComponent");
            if (ServerInstance.Release.COMPONENT) {
                EasyLookup.addNMSClass("network.chat.IChatMutableComponent", "MutableComponent");
                method$fromJson = EasyLookup.staticMethod("ChatSerializer", fromJson, "IChatMutableComponent", String.class, "HolderLookup.Provider");
                method$toJson = EasyLookup.staticMethod("ChatSerializer", toJson, String.class, "IChatBaseComponent", "HolderLookup.Provider");
            } else {
                method$fromJson = EasyLookup.unreflectMethod("ChatSerializer", fromJson, String.class);
                method$toJson = EasyLookup.staticMethod("ChatSerializer", toJson, String.class, "IChatBaseComponent");
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        CHAT_BASE_COMPONENT = EasyLookup.classById("IChatBaseComponent");
        fromString = method$fromString;
        fromComponent = method$fromComponent;
        fromJson = method$fromJson;
        toJson = method$toJson;
    }
}

