/*
 * Decompiled with CFR 0.152.
 */
package com.saicone.rtag.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.saicone.rtag.util.EasyLookup;
import com.saicone.rtag.util.ServerInstance;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullTexture {
    private static final String USER_API = "https://api.mojang.com/users/profiles/minecraft/";
    private static final String SESSION_API = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private static final String INVALID_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDZiYTYzMzQ0ZjQ5ZGQxYzRmNTQ4OGU5MjZiZjNkOWUyYjI5OTE2YTZjNTBkNjEwYmI0MGE1MjczZGM4YzgyIn19fQ==";
    private static final String LOADING_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzI0MzE5MTFmNDE3OGI0ZDJiNDEzYWE3ZjVjNzhhZTQ0NDdmZTkyNDY5NDNjMzFkZjMxMTYzYzBlMDQzZTBkNiJ9fX0=";
    private static final ItemStack PLAYER_HEAD;
    private static final MethodHandle newResolvableProfile;
    private static final MethodHandle getProfile;
    private static final MethodHandle setProfile;
    private static final MethodHandle getValue;
    private static final Cache<String, String> TEXTURE_CACHE;

    SkullTexture() {
    }

    public static ItemStack getTexturedHead(String texture) {
        return SkullTexture.setTexture(new ItemStack(PLAYER_HEAD), SkullTexture.getTextureValue(texture));
    }

    public static ItemStack getTexturedHead(String texture, Consumer<ItemStack> callback) {
        if (callback == null) {
            return SkullTexture.getTexturedHead(texture);
        }
        return SkullTexture.setTexture(new ItemStack(PLAYER_HEAD), SkullTexture.getTextureValue(texture, value -> callback.accept(SkullTexture.setTexture(new ItemStack(PLAYER_HEAD), value))));
    }

    public static ItemStack setTexture(ItemStack head, String texture) throws IllegalArgumentException {
        GameProfile profile = new GameProfile(UUID.randomUUID(), "null");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", SkullTexture.getTextureValue(texture)));
        ItemMeta meta = head.getItemMeta();
        if (!(meta instanceof SkullMeta)) {
            throw new IllegalArgumentException("The provided item isn't a player head");
        }
        try {
            if (newResolvableProfile != null) {
                setProfile.invoke(meta, newResolvableProfile.invoke(profile));
            } else {
                setProfile.invoke(meta, profile);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        head.setItemMeta(meta);
        return head;
    }

    public static String getTextureValue(String texture) {
        return SkullTexture.getTextureValue(texture, null);
    }

    public static String getTextureValue(String texture, Consumer<String> callback) {
        String cachedTexture = (String)TEXTURE_CACHE.getIfPresent((Object)texture);
        if (cachedTexture != null) {
            return cachedTexture;
        }
        cachedTexture = texture.length() <= 20 ? SkullTexture.getPlayerTexture(texture, texture, null, callback) : (texture.length() == 36 ? SkullTexture.getPlayerTexture(texture, null, UUID.fromString(texture), callback) : (texture.length() == 64 ? SkullTexture.parseTextureUrl("http://textures.minecraft.net/texture/" + texture) : (texture.startsWith("http") ? SkullTexture.parseTextureUrl(texture) : texture)));
        TEXTURE_CACHE.put((Object)texture, (Object)cachedTexture);
        return cachedTexture;
    }

    /*
     * Exception decompiling
     */
    private static String getPlayerTexture(String key, String name, UUID uuid, Consumer<String> callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String computePlayerTexture(String name) {
        return SkullTexture.computePlayerTexture(name, name);
    }

    public static String computePlayerTexture(String key, String name) {
        String texture = SkullTexture.requestTextureUrl(name);
        if (texture != null) {
            texture = SkullTexture.parseTextureUrl(texture);
            TEXTURE_CACHE.put((Object)key, (Object)texture);
            return texture;
        }
        TEXTURE_CACHE.put((Object)key, (Object)INVALID_TEXTURE);
        return INVALID_TEXTURE;
    }

    public static String requestTextureUrl(String name) {
        String uuid;
        JsonObject session;
        JsonObject user = SkullTexture.urlJson(USER_API + name);
        if (user != null && user.has("id") && (session = SkullTexture.urlJson(SESSION_API + (uuid = user.get("id").getAsString()))) != null) {
            for (JsonElement element : session.getAsJsonArray("properties")) {
                JsonObject property = element.getAsJsonObject();
                if (!property.get("name").getAsString().equals("textures")) continue;
                String value = property.get("value").getAsString();
                JsonObject texture = SkullTexture.parseJsonObject(new String(Base64.getDecoder().decode(value)));
                if (texture == null) continue;
                return texture.get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").getAsString();
            }
        }
        return null;
    }

    private static JsonObject urlJson(String url) {
        String text = SkullTexture.urlText(url);
        if (text.isBlank()) {
            return null;
        }
        return SkullTexture.parseJsonObject(text);
    }

    private static String urlText(String url) {
        String string;
        block8: {
            InputStream stream = new URL(url).openStream();
            try {
                string = new String(stream.readAllBytes());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return "";
                }
            }
            stream.close();
        }
        return string;
    }

    private static String parseTextureUrl(String url) {
        return new String(Base64.getEncoder().encode(("{\"textures\":{\"SKIN\":{\"url\":\"" + url + "\"}}}").getBytes()));
    }

    private static JsonObject parseJsonObject(String text) {
        try {
            return new JsonParser().parse(text).getAsJsonObject();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static /* synthetic */ void lambda$getPlayerTexture$1(String key, String name, UUID uuid, Consumer callback) {
        String texture = SkullTexture.computePlayerTexture(key, name != null ? name : Bukkit.getOfflinePlayer((UUID)uuid).getName());
        if (callback != null) {
            callback.accept(texture);
        }
    }

    static {
        TEXTURE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.HOURS).build();
        PLAYER_HEAD = ServerInstance.Release.FLAT ? new ItemStack(Material.PLAYER_HEAD) : new ItemStack(Material.getMaterial((String)"SKULL_ITEM"), 1, 3);
        MethodHandle new$ResolvableProfile = null;
        MethodHandle get$profile = null;
        MethodHandle set$profile = null;
        MethodHandle get$value = null;
        try {
            EasyLookup.addOBCClass("entity.CraftPlayer");
            EasyLookup.addOBCClass("inventory.CraftMetaSkull");
            if (ServerInstance.Release.COMPONENT) {
                EasyLookup.addNMSClass("world.item.component.ResolvableProfile");
            }
            get$profile = EasyLookup.method("CraftPlayer", "getProfile", GameProfile.class, new Object[0]);
            if (ServerInstance.MAJOR_VERSION >= 15) {
                for (Method method : EasyLookup.classOf("CraftMetaSkull").getDeclaredMethods()) {
                    if (!method.getName().equals("setProfile") || method.getParameters().length != 1) continue;
                    if (method.getParameters()[0].getType().getSimpleName().equals("ResolvableProfile")) {
                        new$ResolvableProfile = EasyLookup.constructor("ResolvableProfile", GameProfile.class);
                    }
                    set$profile = EasyLookup.unreflectMethod(method);
                }
            } else {
                set$profile = EasyLookup.unreflectSetter("CraftMetaSkull", "profile");
            }
            String value = "value";
            for (Method method : Property.class.getDeclaredMethods()) {
                if (!method.getName().equals("getValue")) continue;
                value = "getValue";
                break;
            }
            get$value = EasyLookup.method(Property.class, value, String.class, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        newResolvableProfile = new$ResolvableProfile;
        getProfile = get$profile;
        setProfile = set$profile;
        getValue = get$value;
    }
}

