/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.collections.indexList;

import java.util.function.Function;
import ru.cwcode.cwutils.collections.indexList.IndexList;

public abstract class Index<K, E> {
    protected final IndexList<E> list;
    protected final Function<E, K> keyExtractor;

    protected Index(IndexList<E> list, Function<E, K> keyExtractor) {
        this.list = list;
        this.keyExtractor = keyExtractor;
        list.registerIndex(this);
        for (int i = 0; i < list.elements.size(); ++i) {
            this.onElementAdded(list.elements.get(i));
        }
    }

    protected abstract void onElementAdded(E var1);

    protected abstract void onElementRemoved(E var1);

    public K keyOf(E e) {
        return this.keyExtractor.apply(e);
    }
}

