/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.cwutils.l10n.L10nPlatform;
import ru.cwcode.cwutils.text.StringToObjectParser;

public class SimpleConfig {
    private final String configName;
    private final L10nPlatform platform;
    Properties fromFile = new Properties();
    Properties fromResources = new Properties();

    public SimpleConfig(String configName, L10nPlatform platform) {
        this.configName = configName;
        this.platform = platform;
        this.loadFile();
        this.loadResources();
        this.saveToFile();
    }

    public String get(String key) {
        return this.get(key, "[Key %s not found in %s]".formatted(key, this.configName));
    }

    public <T> T get(String key, Class<T> type, T defaultVal) {
        String val = this.get(key, null);
        if (val == null) {
            return defaultVal;
        }
        return StringToObjectParser.parse(val, type);
    }

    public String get(String key, String defaultVal) {
        String value = this.fromFile.getProperty(key);
        if (value != null) {
            return value;
        }
        value = this.fromResources.getProperty(key);
        if (value != null) {
            return value;
        }
        return defaultVal;
    }

    public <T> T getParsed(String key, Class<T> type) {
        return StringToObjectParser.parse(this.get(key), type);
    }

    private void saveToFile() {
        Properties effectiveProperties = new Properties();
        effectiveProperties.putAll((Map<?, ?>)this.fromResources);
        effectiveProperties.putAll((Map<?, ?>)this.fromFile);
        try (FileOutputStream os = new FileOutputStream(this.getConfigFile());){
            effectiveProperties.store(os, null);
        }
        catch (Exception e) {
            this.platform.getLogger().error("Cannot store effective config %s".formatted(this.configName));
            e.printStackTrace();
        }
    }

    private void loadResources() {
        try (InputStream inStream = this.platform.getResource("config/" + this.configName + ".properties");){
            this.fromResources.load(inStream);
        }
        catch (Exception e) {
            this.platform.getLogger().error("Cannot read config from resources: %s".formatted(this.configName));
            e.printStackTrace();
        }
    }

    private void loadFile() {
        this.fromFile.clear();
        File file = this.getConfigFile();
        if (!file.exists() || !file.isFile()) {
            return;
        }
        try (FileInputStream inStream = new FileInputStream(file);){
            this.fromFile.load(inStream);
        }
        catch (Exception e) {
            this.platform.getLogger().error("Cannot read config from file: %s".formatted(this.configName));
            e.printStackTrace();
        }
    }

    @NotNull
    private File getConfigFile() {
        Path dataDirectory = this.platform.getDataDirectory();
        dataDirectory.toFile().mkdirs();
        return dataDirectory.resolve(this.configName + ".properties").toFile();
    }
}

