/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.dynamicBossBar.personal;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.cwutils.dynamicBossBar.personal.DynamicBossBar;
import ru.cwcode.cwutils.scheduler.Scheduler;

public class DynamicBossBarManager {
    ConcurrentHashMap<UUID, Set<DynamicBossBar>> bars = new ConcurrentHashMap();
    JavaPlugin plugin;

    public DynamicBossBarManager(JavaPlugin plugin, boolean async, int delay) {
        this.plugin = plugin;
        Scheduler.create().async(async).infinite().perform(this::tick).register(plugin, delay);
    }

    public void send(Player player, DynamicBossBar entry) {
        Set<DynamicBossBar> bossBarEntries = this.getBossBarEntries(player);
        this.removeBar(player, entry.getUUID());
        bossBarEntries.add(entry);
    }

    @NotNull
    public Set<DynamicBossBar> getBossBarEntries(Player player) {
        return this.bars.computeIfAbsent(player.getUniqueId(), uuid -> new HashSet());
    }

    private void tick() {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            Set<DynamicBossBar> bossBarEntries = this.bars.get(onlinePlayer.getUniqueId());
            if (bossBarEntries == null || bossBarEntries.isEmpty()) continue;
            bossBarEntries.removeIf(bar -> {
                if (bar.getShouldRemove().get().booleanValue()) {
                    bar.onRemove();
                    return true;
                }
                bar.update(onlinePlayer);
                return false;
            });
        }
    }

    public void removeBar(Player player, UUID bar) {
        this.getBossBarEntries(player).removeIf(x -> {
            if (x.getUUID().equals(bar)) {
                x.onRemove();
                return true;
            }
            return false;
        });
    }
}

