/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.items;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SimilarMode {
    MATERIAL{

        @Override
        public boolean compare(ItemStack item1, ItemStack item2) {
            if (super.compare(item1, item2)) {
                return item1.getType() == item2.getType();
            }
            return false;
        }
    }
    ,
    DURABILITY{

        @Override
        public boolean compare(ItemStack item1, ItemStack item2) {
            if (super.compare(item1, item2)) {
                boolean item1Damageable = item1.getItemMeta() instanceof Damageable;
                boolean item2Damageable = item2.getItemMeta() instanceof Damageable;
                if (!item1Damageable && !item2Damageable) {
                    return true;
                }
                if (!item1Damageable || !item2Damageable) {
                    return false;
                }
                return ((Damageable)item1).getDamage() == ((Damageable)item2).getDamage();
            }
            return false;
        }
    }
    ,
    DISPLAYNAME{

        @Override
        public boolean compare(ItemStack item1, ItemStack item2) {
            if (super.compare(item1, item2)) {
                Component item1DisplayName = item1.getItemMeta().displayName();
                Component item2DisplayName = item2.getItemMeta().displayName();
                if (item1DisplayName == null && item2DisplayName == null) {
                    return true;
                }
                if (item1DisplayName == null || item2DisplayName == null) {
                    return false;
                }
                String item1DisplayNameText = LegacyComponentSerializer.legacySection().serialize(item1DisplayName);
                String item2DisplayNameText = LegacyComponentSerializer.legacySection().serialize(item2DisplayName);
                return item1DisplayNameText.equals(item2DisplayNameText);
            }
            return false;
        }
    }
    ,
    LORE{

        @Override
        public boolean compare(ItemStack item1, ItemStack item2) {
            if (super.compare(item1, item2)) {
                List item1Lore = item1.getItemMeta().lore();
                List item2Lore = item2.getItemMeta().lore();
                if (item1Lore == null && item2Lore == null) {
                    return true;
                }
                if (item1Lore == null || item2Lore == null) {
                    return false;
                }
                if (item1Lore.size() != item2Lore.size()) {
                    return false;
                }
                if (item1Lore.isEmpty()) {
                    return true;
                }
                for (int index = 0; index < item1Lore.size(); ++index) {
                    String item2LoreLineText;
                    Component item1LoreLine = (Component)item1Lore.get(index);
                    Component item2LoreLine = (Component)item2Lore.get(index);
                    if (item1LoreLine == null && item2LoreLine == null) continue;
                    if (item1LoreLine == null || item2LoreLine == null) {
                        return false;
                    }
                    String item1LoreLineText = LegacyComponentSerializer.legacySection().serialize(item1LoreLine);
                    if (item1LoreLineText.equals(item2LoreLineText = LegacyComponentSerializer.legacySection().serialize(item2LoreLine))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };


    public boolean compare(ItemStack item1, ItemStack item2) {
        return item1 != null && item2 != null;
    }
}

