/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.cwutils.items.rechargable;

import java.time.Duration;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import ru.cwcode.cwutils.datetime.TimeFormatter;

public interface RechargeableItem {
    public long getRecharge(NamespacedKey var1);

    default public long getRecharge() {
        return this.getRecharge(this.getRechargeKey());
    }

    public NamespacedKey getRechargeKey(String var1);

    default public NamespacedKey getRechargeKey() {
        return this.getRechargeKey("");
    }

    default public long getTimestamp(NamespacedKey rechargeKey, ItemStack itemStack) {
        return (Long)itemStack.getItemMeta().getPersistentDataContainer().getOrDefault(rechargeKey, PersistentDataType.LONG, (Object)0L);
    }

    default public long getTimestamp(ItemStack itemStack) {
        NamespacedKey rechargeKey = this.getRechargeKey();
        return this.getTimestamp(rechargeKey, itemStack);
    }

    default public long getRechargeExpire(NamespacedKey rechargeKey, ItemStack itemStack) {
        return this.getTimestamp(rechargeKey, itemStack) + this.getRecharge(rechargeKey) * 1000L;
    }

    default public long getRechargeExpire(ItemStack itemStack) {
        NamespacedKey rechargeKey = this.getRechargeKey();
        return this.getRechargeExpire(rechargeKey, itemStack);
    }

    default public boolean isInRecharge(NamespacedKey rechargeKey, ItemStack itemStack) {
        long rechargeExpire = this.getRechargeExpire(rechargeKey, itemStack);
        return rechargeExpire > System.currentTimeMillis();
    }

    default public boolean isInRecharge(ItemStack itemStack) {
        NamespacedKey rechargeKey = this.getRechargeKey();
        return this.isInRecharge(rechargeKey, itemStack);
    }

    default public void setRecharge(NamespacedKey rechargeKey, ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        itemMeta.getPersistentDataContainer().set(rechargeKey, PersistentDataType.LONG, (Object)System.currentTimeMillis());
        itemStack.setItemMeta(itemMeta);
    }

    default public void setRecharge(ItemStack itemStack) {
        NamespacedKey rechargeKey = this.getRechargeKey();
        this.setRecharge(rechargeKey, itemStack);
    }

    default public long getRechargeRemain(NamespacedKey rechargeKey, ItemStack itemStack) {
        long expire = this.getRechargeExpire(rechargeKey, itemStack);
        return Math.max(expire - System.currentTimeMillis(), 0L);
    }

    default public long getRechargeRemain(ItemStack itemStack) {
        NamespacedKey rechargeKey = this.getRechargeKey();
        return this.getRechargeRemain(rechargeKey, itemStack);
    }

    default public String getRechargeRemainTime(Duration duration) {
        return TimeFormatter.getFormattedTime(duration);
    }

    default public String getRechargeRemainTime(NamespacedKey rechargeKey, ItemStack itemStack) {
        long rechargeRemain = this.getRechargeRemain(rechargeKey, itemStack);
        return this.getRechargeRemainTime(Duration.ofMillis(rechargeRemain));
    }

    default public String getRechargeRemainTime(ItemStack itemStack) {
        NamespacedKey rechargeKey = this.getRechargeKey();
        return this.getRechargeRemainTime(rechargeKey, itemStack);
    }
}

