/*
 * Decompiled with CFR 0.152.
 */
package ru.dimgel.lib.web.core.session;

import java.rmi.RemoteException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.codec.digest.DigestUtils;
import ru.dimgel.lib.web.core.Main;
import ru.dimgel.lib.web.core.request.Request;
import ru.dimgel.lib.web.core.session.CustomSession;
import ru.dimgel.lib.web.core.session.CustomSessionController$;
import ru.dimgel.lib.web.core.session.SessionController;
import ru.dimgel.lib.web.header.Header;
import ru.dimgel.lib.web.header.UserAgent;
import ru.dimgel.lib.web.header.UserAgent$;
import ru.dimgel.lib.web.state.StateStorage;
import scala.Function1;
import scala.Math$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.StringBuilder;
import scala.reflect.Manifest;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CustomSessionController<D>
extends SessionController<D, CustomSession<D>>
implements ScalaObject {
    private final Timer gcTimer;
    private final Main main;

    public CustomSessionController(Main main, Manifest<D> mD) {
        this.main = main;
        super(main, mD);
        this.gcTimer = new Timer();
    }

    private final String imp$1(int attempt, Request request) {
        String key;
        while (true) {
            Predef$.MODULE$.assert(attempt <= 10, (Object)"Failed to generate unique id");
            String ip = request.remoteAddr();
            Option<UserAgent> hOpt = request.headers().get(UserAgent$.MODULE$);
            String ua = hOpt.isEmpty() ? "undefined" : ((Header)hOpt.get()).serialization();
            long time2 = new Date().getTime();
            double rand = Math$.MODULE$.random();
            key = DigestUtils.md5Hex((String)new StringBuilder().append((Object)ip).append((Object)" --- ").append((Object)ua).append((Object)" --- ").append((Object)BoxesRunTime.boxToLong((long)time2)).append((Object)" --- ").append((Object)BoxesRunTime.boxToDouble((double)rand)).toString());
            if (!this.stateStorage().contains(key)) break;
            ++attempt;
        }
        return key;
    }

    @Override
    public void mainBeforeDestroy() {
        this.gcTimer().cancel();
    }

    @Override
    public void mainAfterInit() {
        this.gcTimer().schedule((TimerTask)new $anon$1(this), Predef$.MODULE$.int2long(this.gcInterval() * 1000), Predef$.MODULE$.int2long(this.gcInterval() * 1000));
    }

    private Timer gcTimer() {
        return this.gcTimer;
    }

    public String generateKey(Request rq$1) {
        return this.imp$1(1, rq$1);
    }

    @Override
    public Option<CustomSession<D>> getSession(Request rq, boolean create2) {
        Main main = rq.rb().main();
        Main main2 = this.main;
        Predef$.MODULE$.assert(!(main != null ? !main.equals(main2) : main2 != null), (Object)"Request belongs to different Main instance");
        Option existing = rq.rb().sessions().find((Function1)new $anonfun$1(this));
        if (existing.isEmpty()) {
            Some some;
            Option<Object> dataHolderOpt;
            Option sessionIdOpt = rq.cookies().get((Object)this.cookieName()).map((Function1)new $anonfun$2(this));
            Option<Object> option = dataHolderOpt = sessionIdOpt.isEmpty() ? None$.MODULE$ : this.stateStorage().get((String)sessionIdOpt.get());
            if (dataHolderOpt.isEmpty()) {
                if (create2) {
                    long now = new Date().getTime();
                    DataHolder dataHolder = new DataHolder(this.generateKey(rq), rq.remoteAddr(), now, now, None$.MODULE$);
                    some = new Some(new CustomSession(this, rq, dataHolder));
                } else {
                    some = None$.MODULE$;
                }
            } else {
                some = new Some(new CustomSession(this, rq, (DataHolder)dataHolderOpt.get()));
            }
            return some;
        }
        return existing;
    }

    public abstract StateStorage stateStorage();

    public int gcInterval() {
        return 60;
    }

    public boolean restrictIP() {
        return false;
    }

    public Some<String> cookiePath(Request rq) {
        return new Some((Object)rq.baseUri());
    }

    public None$ cookieDomain(Request rq) {
        return None$.MODULE$;
    }

    public String cookieName() {
        return "JSESSIONID";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataHolder<D>
    implements ScalaObject {
        private Option<D> data;
        private long accessed;
        private final long created;
        private final String ip;
        private final String id;

        public DataHolder(String id, String ip, long created, long accessed, Option<D> data) {
            this.id = id;
            this.ip = ip;
            this.created = created;
            this.accessed = accessed;
            this.data = data;
        }

        public void data_$eq(Option<D> x$1) {
            this.data = x$1;
        }

        public Option<D> data() {
            return this.data;
        }

        public void accessed_$eq(long x$1) {
            this.accessed = x$1;
        }

        public long accessed() {
            return this.accessed;
        }

        public long created() {
            return this.created;
        }

        public String ip() {
            return this.ip;
        }

        public String id() {
            return this.id;
        }

        public int $tag() throws RemoteException {
            return ScalaObject.class.$tag((ScalaObject)this);
        }
    }
}

