/*
 * Decompiled with CFR 0.152.
 */
package ru.dimgel.lib.web.header;

import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import ru.dimgel.lib.web.header.HeaderParser$;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.StringBuilder;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HeaderParser$
implements ScalaObject {
    public static final HeaderParser$ MODULE$;
    private final SimpleDateFormat dateFormat;
    private final Locale timeLocale;
    private final TimeZone timeZone;

    static {
        new HeaderParser$();
    }

    /*
     * WARNING - void declaration
     */
    public HeaderParser$() {
        void var1_1;
        MODULE$ = this;
        this.timeZone = TimeZone.getTimeZone("GMT");
        this.timeLocale = Locale.US;
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", this.timeLocale());
        df.setTimeZone(this.timeZone());
        this.dateFormat = var1_1;
    }

    public String toDate(long timestamp) {
        return this.dateFormat().format(new Date(timestamp));
    }

    public final long ru$dimgel$lib$web$header$HeaderParser$$makeTimestamp(int year, int month2, int day) {
        Calendar calendar = Calendar.getInstance(this.timeZone(), this.timeLocale());
        calendar.clear();
        calendar.set(year, month2 - 1, day);
        return calendar.getTimeInMillis();
    }

    private SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    private Locale timeLocale() {
        return this.timeLocale;
    }

    private TimeZone timeZone() {
        return this.timeZone;
    }

    public String toValue(String s) {
        return this.isToken(s) ? s : this.toQuotedString(s);
    }

    public String toQuotedString_utf8(String s) {
        StringBuilder sb$2 = new StringBuilder();
        sb$2.append('\"');
        Predef$.MODULE$.stringWrapper(s).foreach((Function1)new anonfun.toQuotedString_utf8.1(sb$2));
        sb$2.append('\"');
        return sb$2.toString();
    }

    public String toQuotedString(String s) {
        StringBuilder sb$1 = new StringBuilder();
        sb$1.append('\"');
        Predef$.MODULE$.stringWrapper(s).foreach((Function1)new anonfun.toQuotedString.1(sb$1));
        sb$1.append('\"');
        return sb$1.toString();
    }

    public Map<Character, Character> unescapeCharMap() {
        return Predef$.MODULE$.Map().apply((Seq)new BoxedObjectArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'0')).$minus$greater((Object)BoxesRunTime.boxToCharacter((char)'\u0000')), Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'r')).$minus$greater((Object)BoxesRunTime.boxToCharacter((char)'\r')), Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'n')).$minus$greater((Object)BoxesRunTime.boxToCharacter((char)'\n')), Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'t')).$minus$greater((Object)BoxesRunTime.boxToCharacter((char)'\t'))}));
    }

    public Map<Character, String> escapeCharMap() {
        return Predef$.MODULE$.Map().apply((Seq)new BoxedObjectArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'\u0000')).$minus$greater((Object)"\\0"), Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'\r')).$minus$greater((Object)"\\r"), Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'\n')).$minus$greater((Object)"\\n"), Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'\t')).$minus$greater((Object)"\\t")}));
    }

    public void assertValue(String s, String fieldName) {
        Predef$.MODULE$.assert(this.isQuotedString(s), (Object)new StringBuilder().append((Object)fieldName).append((Object)" is not a token or quoted-string").toString());
    }

    public void assertQuotedString(String s, String fieldName) {
        Predef$.MODULE$.assert(this.isQuotedString(s), (Object)new StringBuilder().append((Object)fieldName).append((Object)" is not a quoted-string").toString());
    }

    public void assertToken(String s, String fieldName) {
        Predef$.MODULE$.assert(this.isToken(s), (Object)new StringBuilder().append((Object)fieldName).append((Object)" is not a token").toString());
    }

    private boolean isQuotedString(String s) {
        String string = s;
        return string != null && !string.equals(null) && Predef$.MODULE$.stringWrapper(s).forall((Function1)new anonfun.isQuotedString.1());
    }

    public final boolean ru$dimgel$lib$web$header$HeaderParser$$isQuotedStringChar(char c) {
        return this.ru$dimgel$lib$web$header$HeaderParser$$isChar(c) || this.ru$dimgel$lib$web$header$HeaderParser$$isText(c) && c != '\"';
    }

    private boolean isToken(String s) {
        String string = s;
        return string != null && !string.equals(null) && Predef$.MODULE$.stringWrapper(s).forall((Function1)new anonfun.isToken.1());
    }

    public final boolean ru$dimgel$lib$web$header$HeaderParser$$isTokenChar(char c) {
        return this.ru$dimgel$lib$web$header$HeaderParser$$isChar(c) && !this.ru$dimgel$lib$web$header$HeaderParser$$isCTL(c) && !this.isSeparator(c);
    }

    private boolean isSeparator(char c) {
        return "()<>@,;:\\\"/[]?={} \t".indexOf(Predef$.MODULE$.char2int(c)) >= 0;
    }

    public boolean isText_utf8(char c) {
        return !this.ru$dimgel$lib$web$header$HeaderParser$$isCTL(c) || this.isLWS(c);
    }

    public final boolean ru$dimgel$lib$web$header$HeaderParser$$isText(char c) {
        return this.isOctet(c) && (!this.ru$dimgel$lib$web$header$HeaderParser$$isCTL(c) || this.isLWS(c));
    }

    private boolean isLWS(char c) {
        return "\r\n \t".indexOf(Predef$.MODULE$.char2int(c)) >= 0;
    }

    public final boolean ru$dimgel$lib$web$header$HeaderParser$$isCTL(char c) {
        return c < ' ' || c == '\u007f';
    }

    public final boolean ru$dimgel$lib$web$header$HeaderParser$$isChar(char c) {
        return c >= '\u0000' && c <= '\u007f';
    }

    private boolean isOctet(char c) {
        return c >= '\u0000' && c <= '\u00ff';
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

