/*
 * Decompiled with CFR 0.152.
 */
package ru.dimgel.lib.web.state;

import java.rmi.RemoteException;
import java.util.Date;
import ru.dimgel.lib.web.state.StateHandler;
import ru.dimgel.lib.web.state.StateStorage$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StateStorage
implements StateHandler,
ScalaObject {
    private final long maxAge;

    public StateStorage(long maxAge) {
        this.maxAge = maxAge;
    }

    public final boolean isKey(String s) {
        return StateStorage$.MODULE$.isKey(s);
    }

    public final long now() {
        return new Date().getTime();
    }

    public abstract void gcImp(long var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void gc() {
        if (this.maxAge() <= 0L) return;
        StateStorage stateStorage = this;
        synchronized (stateStorage) {
            this.gcImp(this.now() - this.maxAge());
            return;
        }
    }

    public abstract void removeImp(String var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void remove(String key) {
        if (!StateStorage$.MODULE$.isKey(key)) return;
        StateStorage stateStorage = this;
        synchronized (stateStorage) {
            this.removeImp(key);
            return;
        }
    }

    public final boolean contains(String key) {
        return !this.get(key).isEmpty();
    }

    public abstract Option<Object> getImp(String var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Option<Object> get(String key) {
        Option<Object> option;
        if (!StateStorage$.MODULE$.isKey(key)) {
            option = None$.MODULE$;
            return option;
        }
        StateStorage stateStorage = this;
        synchronized (stateStorage) {
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : stateStorage
            option = this.getImp(key);
            return option;
        }
    }

    public abstract void putImp(String var1, Object var2);

    public final void put(String key, Object obj) {
        Predef$.MODULE$.assert(StateStorage$.MODULE$.isKey(key), (Object)"Invalid key");
        StateStorage stateStorage = this;
        synchronized (stateStorage) {
            this.putImp(key, obj);
            return;
        }
    }

    @Override
    public final String put(Object obj) {
        String key = StateStorage$.MODULE$.generateKey();
        StateStorage stateStorage = this;
        synchronized (stateStorage) {
            this.putImp(key, obj);
            return key;
        }
    }

    public long maxAge() {
        return this.maxAge;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

