/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import ru.dlabs71.library.email.client.receiver.IMAPDClient;
import ru.dlabs71.library.email.client.receiver.ReceiverDClient;
import ru.dlabs71.library.email.dto.message.common.EmailParticipant;
import ru.dlabs71.library.email.dto.message.incoming.IncomingMessage;
import ru.dlabs71.library.email.dto.message.incoming.MessageView;
import ru.dlabs71.library.email.dto.pageable.PageRequest;
import ru.dlabs71.library.email.dto.pageable.PageResponse;
import ru.dlabs71.library.email.property.ImapProperties;
import ru.dlabs71.library.email.util.JavaCoreUtils;

public final class DEmailReceiver {
    public static final PageRequest DEFAULT_PAGE_REQUEST = PageRequest.of(0, 50);
    public static final String FOLDER_NAME_KEY_METADATA = "folderName";
    private final ReceiverDClient receiverClient;
    private String folderName = "INBOX";

    public DEmailReceiver(ImapProperties properties) {
        this.receiverClient = new IMAPDClient(properties);
    }

    public static DEmailReceiver of(ImapProperties properties) {
        return new DEmailReceiver(properties);
    }

    public synchronized DEmailReceiver folder(String folderName) {
        this.folderName = folderName;
        return this;
    }

    public EmailParticipant receiver() {
        return this.receiverClient.getPrincipal();
    }

    public String getCurrentFolder() {
        return this.folderName;
    }

    public PageResponse<MessageView> checkEmail() {
        return this.checkEmail(DEFAULT_PAGE_REQUEST);
    }

    public PageResponse<MessageView> checkEmail(PageRequest pageRequest) {
        String currentFolderName = this.folderName;
        int totalCount = this.receiverClient.getTotalCount(currentFolderName);
        Map<String, Object> metadata = JavaCoreUtils.makeMap(FOLDER_NAME_KEY_METADATA, currentFolderName);
        if (totalCount <= 0 || totalCount < pageRequest.getStart()) {
            return PageResponse.of(new ArrayList(), totalCount, metadata);
        }
        List<MessageView> messageViews = this.receiverClient.checkEmailMessages(currentFolderName, pageRequest);
        return PageResponse.of(messageViews, totalCount, metadata);
    }

    public PageResponse<IncomingMessage> readEmail() {
        return this.readEmail(DEFAULT_PAGE_REQUEST);
    }

    public PageResponse<IncomingMessage> readEmail(PageRequest pageRequest) {
        String currentFolderName = this.folderName;
        int totalCount = this.receiverClient.getTotalCount(currentFolderName);
        Map<String, Object> metadata = JavaCoreUtils.makeMap(FOLDER_NAME_KEY_METADATA, currentFolderName);
        if (totalCount <= 0 || totalCount <= pageRequest.getStart()) {
            return PageResponse.of(new ArrayList(), totalCount, metadata);
        }
        List<IncomingMessage> messages = this.receiverClient.readMessages(currentFolderName, pageRequest);
        return PageResponse.of(messages, totalCount, metadata);
    }

    public IncomingMessage readMessageById(Integer id) {
        if (id == null) {
            return null;
        }
        return this.receiverClient.readMessageById(this.folderName, id);
    }

    public Map<Integer, Boolean> clearCurrentFolder() {
        return this.receiverClient.deleteAllMessages(this.folderName);
    }

    public Map<Integer, Boolean> deleteMessages(Collection<Integer> ids) {
        return this.receiverClient.deleteMessages(this.folderName, ids);
    }

    public boolean deleteMessageById(Integer id) {
        return this.receiverClient.deleteMessage(this.folderName, id);
    }
}

