/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.dlabs71.library.email.client.sender.SMTPDClient;
import ru.dlabs71.library.email.client.sender.SenderDClient;
import ru.dlabs71.library.email.dto.message.common.EmailAttachment;
import ru.dlabs71.library.email.dto.message.common.EmailParticipant;
import ru.dlabs71.library.email.dto.message.outgoing.DefaultOutgoingMessage;
import ru.dlabs71.library.email.dto.message.outgoing.OutgoingMessage;
import ru.dlabs71.library.email.dto.message.outgoing.TemplatedOutgoingMessage;
import ru.dlabs71.library.email.exception.CreateMessageException;
import ru.dlabs71.library.email.exception.TemplateCreationException;
import ru.dlabs71.library.email.property.SmtpProperties;
import ru.dlabs71.library.email.type.ContentMessageType;
import ru.dlabs71.library.email.type.SendingStatus;

public final class DEmailSender {
    private final SenderDClient senderClient;
    private final Charset defaultCharset;

    private DEmailSender(SmtpProperties smtpProperties) {
        this.defaultCharset = smtpProperties.getCharset();
        this.senderClient = new SMTPDClient(smtpProperties);
    }

    public static DEmailSender of(SmtpProperties properties) {
        return new DEmailSender(properties);
    }

    public EmailParticipant sender() {
        return this.senderClient.getPrincipal();
    }

    public SendingStatus sendText(String email, String subject, String content) {
        return this.sendText(email, subject, content, new ArrayList<EmailAttachment>());
    }

    public SendingStatus sendText(Collection<String> emails, String subject, String content) {
        return this.sendText(emails, subject, content, new ArrayList<EmailAttachment>());
    }

    public SendingStatus sendText(Collection<String> emails, String subject, String content, EmailAttachment ... attachments) {
        return this.sendText(emails, subject, content, Arrays.asList(attachments));
    }

    public SendingStatus sendText(Collection<String> emails, String subject, String content, List<EmailAttachment> attachments) {
        Set<EmailParticipant> recipients = emails.stream().map(EmailParticipant::new).collect(Collectors.toSet());
        return this.sendText(recipients, subject, content, attachments);
    }

    public SendingStatus sendText(String email, String subject, String content, EmailAttachment ... attachments) {
        return this.sendText(email, subject, content, Arrays.asList(attachments));
    }

    public SendingStatus sendText(String email, String subject, String content, List<EmailAttachment> attachments) {
        HashSet<EmailParticipant> recipients = new HashSet<EmailParticipant>();
        recipients.add(new EmailParticipant(email));
        return this.sendText((Set<EmailParticipant>)recipients, subject, content, attachments);
    }

    public SendingStatus sendText(Set<EmailParticipant> recipients, String subject, String content, List<EmailAttachment> attachments) {
        return this.send(recipients, subject, content, ContentMessageType.TEXT, null, attachments);
    }

    public SendingStatus sendHtml(String email, String subject, String content) {
        return this.sendHtml(email, subject, content, new ArrayList<EmailAttachment>());
    }

    public SendingStatus sendHtml(Collection<String> emails, String subject, String content) {
        return this.sendHtml(emails, subject, content, new ArrayList<EmailAttachment>());
    }

    public SendingStatus sendHtml(Set<String> emails, String subject, String content, EmailAttachment ... attachments) {
        return this.sendHtml((Collection<String>)emails, subject, content, Arrays.asList(attachments));
    }

    public SendingStatus sendHtml(Collection<String> emails, String subject, String content, List<EmailAttachment> attachments) {
        Set<EmailParticipant> recipients = emails.stream().map(EmailParticipant::new).collect(Collectors.toSet());
        return this.sendHtml(recipients, subject, content, attachments);
    }

    public SendingStatus sendHtml(Collection<String> emails, String subject, String content, EmailAttachment ... attachments) {
        Set<EmailParticipant> recipients = emails.stream().map(EmailParticipant::new).collect(Collectors.toSet());
        return this.sendHtml(recipients, subject, content, Arrays.asList(attachments));
    }

    public SendingStatus sendHtml(String email, String subject, String content, EmailAttachment ... attachments) {
        return this.sendHtml(email, subject, content, Arrays.asList(attachments));
    }

    public SendingStatus sendHtml(String email, String subject, String content, List<EmailAttachment> attachments) {
        HashSet<EmailParticipant> recipients = new HashSet<EmailParticipant>();
        recipients.add(new EmailParticipant(email));
        return this.sendHtml((Set<EmailParticipant>)recipients, subject, content, attachments);
    }

    public SendingStatus sendHtml(Set<EmailParticipant> recipients, String subject, String content, List<EmailAttachment> attachments) {
        return this.send(recipients, subject, content, ContentMessageType.HTML, null, attachments);
    }

    public SendingStatus sendHtmlTemplated(String email, String subject, String pathToTemplate, Map<String, Object> params) {
        return this.sendHtmlTemplated(email, subject, pathToTemplate, params, new ArrayList<EmailAttachment>());
    }

    public SendingStatus sendHtmlTemplated(Collection<String> emails, String subject, String pathToTemplate, Map<String, Object> params) {
        return this.sendHtmlTemplated(emails, subject, pathToTemplate, params, new ArrayList<EmailAttachment>());
    }

    public SendingStatus sendHtmlTemplated(Collection<String> emails, String subject, String pathToTemplate, Map<String, Object> params, EmailAttachment ... attachments) {
        return this.sendHtmlTemplated(emails, subject, pathToTemplate, params, Arrays.asList(attachments));
    }

    public SendingStatus sendHtmlTemplated(Collection<String> emails, String subject, String pathToTemplate, Map<String, Object> params, List<EmailAttachment> attachments) {
        Set<EmailParticipant> recipients = emails.stream().map(EmailParticipant::new).collect(Collectors.toSet());
        return this.sendHtmlTemplated(recipients, subject, pathToTemplate, params, attachments);
    }

    public SendingStatus sendHtmlTemplated(String email, String subject, String pathToTemplate, Map<String, Object> params, EmailAttachment ... attachments) {
        return this.sendHtmlTemplated(email, subject, pathToTemplate, params, Arrays.asList(attachments));
    }

    public SendingStatus sendHtmlTemplated(String email, String subject, String pathToTemplate, Map<String, Object> params, List<EmailAttachment> attachments) {
        HashSet<EmailParticipant> recipients = new HashSet<EmailParticipant>();
        recipients.add(new EmailParticipant(email));
        return this.sendHtmlTemplated((Set<EmailParticipant>)recipients, subject, pathToTemplate, params, attachments);
    }

    public SendingStatus sendHtmlTemplated(Set<EmailParticipant> recipients, String subject, String pathToTemplate, Map<String, Object> params, List<EmailAttachment> attachments) {
        return this.sendTemplatedMessage(recipients, subject, pathToTemplate, params, ContentMessageType.HTML, null, attachments);
    }

    public SendingStatus sendTextTemplated(String email, String subject, String pathToTemplate, Map<String, Object> params) {
        return this.sendTextTemplated(email, subject, pathToTemplate, params, new ArrayList<EmailAttachment>());
    }

    public SendingStatus sendTextTemplated(Collection<String> emails, String subject, String pathToTemplate, Map<String, Object> params) {
        return this.sendTextTemplated(emails, subject, pathToTemplate, params, new ArrayList<EmailAttachment>());
    }

    public SendingStatus sendTextTemplated(Collection<String> emails, String subject, String pathToTemplate, Map<String, Object> params, EmailAttachment ... attachments) {
        return this.sendTextTemplated(emails, subject, pathToTemplate, params, Arrays.asList(attachments));
    }

    public SendingStatus sendTextTemplated(Collection<String> emails, String subject, String pathToTemplate, Map<String, Object> params, List<EmailAttachment> attachments) {
        Set<EmailParticipant> recipients = emails.stream().map(EmailParticipant::new).collect(Collectors.toSet());
        return this.sendTextTemplated(recipients, subject, pathToTemplate, params, attachments);
    }

    public SendingStatus sendTextTemplated(String email, String subject, String pathToTemplate, Map<String, Object> params, EmailAttachment ... attachments) {
        return this.sendTextTemplated(email, subject, pathToTemplate, params, Arrays.asList(attachments));
    }

    public SendingStatus sendTextTemplated(String email, String subject, String pathToTemplate, Map<String, Object> params, List<EmailAttachment> attachments) {
        HashSet<EmailParticipant> recipients = new HashSet<EmailParticipant>();
        recipients.add(new EmailParticipant(email));
        return this.sendTextTemplated((Set<EmailParticipant>)recipients, subject, pathToTemplate, params, attachments);
    }

    public SendingStatus sendTextTemplated(Set<EmailParticipant> recipients, String subject, String pathToTemplate, Map<String, Object> params, List<EmailAttachment> attachments) {
        return this.sendTemplatedMessage(recipients, subject, pathToTemplate, params, ContentMessageType.TEXT, null, attachments);
    }

    public SendingStatus sendTemplatedMessage(Set<EmailParticipant> recipients, String subject, String pathToTemplate, Map<String, Object> params, ContentMessageType contentType, Charset charsetContent, List<EmailAttachment> attachments) {
        TemplatedOutgoingMessage message;
        try {
            message = TemplatedOutgoingMessage.builder().recipientEmail(recipients).subject(subject).template(pathToTemplate, params).charsetContent(charsetContent == null ? this.defaultCharset : charsetContent).contentType(contentType).attachments(attachments).build();
        }
        catch (TemplateCreationException e) {
            throw new CreateMessageException(e.getMessage(), e);
        }
        return this.send(message);
    }

    public SendingStatus send(Set<EmailParticipant> recipients, String subject, String content, ContentMessageType contentType, Charset charsetContent, List<EmailAttachment> attachments) {
        DefaultOutgoingMessage message = DefaultOutgoingMessage.outgoingMessageBuilder().recipientEmail(recipients).subject(subject).content(content).contentType(contentType).charsetContent(charsetContent == null ? this.defaultCharset : charsetContent).attachments(attachments).build();
        return this.send(message);
    }

    public SendingStatus send(OutgoingMessage message) {
        return this.senderClient.send(message);
    }
}

