/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.client.sender;

import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.dlabs71.library.email.client.sender.SenderDClient;
import ru.dlabs71.library.email.converter.outgoing.JakartaMessageConverter;
import ru.dlabs71.library.email.dto.message.common.EmailParticipant;
import ru.dlabs71.library.email.dto.message.outgoing.OutgoingMessage;
import ru.dlabs71.library.email.exception.CreateMessageException;
import ru.dlabs71.library.email.exception.SessionException;
import ru.dlabs71.library.email.property.SessionPropertyCollector;
import ru.dlabs71.library.email.property.SmtpProperties;
import ru.dlabs71.library.email.type.Protocol;
import ru.dlabs71.library.email.type.SendingStatus;
import ru.dlabs71.library.email.util.JavaCoreUtils;
import ru.dlabs71.library.email.util.MessageValidator;
import ru.dlabs71.library.email.util.RetryableUtils;

public class SMTPDClient
implements SenderDClient {
    private static final Logger log = LoggerFactory.getLogger(SMTPDClient.class);
    private static final Protocol PROTOCOL = Protocol.SMTP;
    private final Session session;
    private final Properties properties;
    private final PasswordAuthentication authentication;
    private final EmailParticipant principal;
    private final int maxAttemptsOfRequest;
    private final int attemptDelayOfRequest;

    public SMTPDClient(SmtpProperties smtpProperties) {
        JavaCoreUtils.notNullArgument(smtpProperties, "smtpProperties");
        this.principal = new EmailParticipant(smtpProperties.getEmail(), smtpProperties.getName());
        this.authentication = new PasswordAuthentication(smtpProperties.getEmail(), smtpProperties.getPassword());
        this.maxAttemptsOfRequest = smtpProperties.getMaxAttemptsOfRequest();
        this.attemptDelayOfRequest = smtpProperties.getAttemptDelayOfRequest();
        log.debug("Principal and authentication object were created. {}", (Object)this.principal);
        try {
            this.properties = SessionPropertyCollector.createCommonProperties(smtpProperties, PROTOCOL);
            this.properties.put("mail.smtp.auth", "true");
        }
        catch (Exception e) {
            throw new SessionException("The creation of a connection failed because of the following error: " + e.getMessage());
        }
        log.debug("Configuration properties were created");
        this.session = this.connect();
        log.debug("Session was created. Client is ready to sending messages!");
    }

    @Override
    public Session connect() throws SessionException {
        Authenticator auth = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return SMTPDClient.this.authentication;
            }
        };
        try {
            return Session.getInstance((Properties)this.properties, (Authenticator)auth);
        }
        catch (Exception e) {
            throw new SessionException("The creation of a connection failed because of the following error: " + e.getMessage());
        }
    }

    @Override
    public final String getProtocolName() {
        return PROTOCOL.getProtocolName();
    }

    @Override
    public final EmailParticipant getPrincipal() {
        return this.principal;
    }

    @Override
    public SendingStatus send(OutgoingMessage message) {
        Message jakartaMessage;
        MessageValidator.validate(message);
        log.debug("Starts sending message. Message is {}", (Object)message);
        try {
            jakartaMessage = JakartaMessageConverter.convert(message, this.session, this.principal.getEmail(), this.principal.getName());
        }
        catch (MessagingException | CreateMessageException ex) {
            log.error("Convert outgoing message DTO to jakarta message object failed by the next reason: " + ex.getMessage(), ex);
            return SendingStatus.ERROR_IN_MESSAGE;
        }
        try {
            RetryableUtils.retry(this.maxAttemptsOfRequest, (long)this.attemptDelayOfRequest, () -> Transport.send((Message)jakartaMessage));
        }
        catch (MessagingException ex) {
            log.error("Message couldn't be sent due to the following error: " + ex.getMessage(), (Throwable)ex);
            return SendingStatus.ERROR_IN_TRANSPORT;
        }
        return SendingStatus.SUCCESS;
    }
}

