/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.converter.incoming;

import jakarta.mail.Address;
import jakarta.mail.Flags;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.util.List;
import org.eclipse.angus.mail.imap.IMAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.dlabs71.library.email.converter.incoming.MessagePartConverter;
import ru.dlabs71.library.email.dto.message.common.BaseMessage;
import ru.dlabs71.library.email.dto.message.common.ContentMessage;
import ru.dlabs71.library.email.dto.message.common.EmailParticipant;
import ru.dlabs71.library.email.dto.message.incoming.DefaultIncomingMessage;
import ru.dlabs71.library.email.exception.CheckEmailException;
import ru.dlabs71.library.email.type.TransferEncoder;
import ru.dlabs71.library.email.util.EmailMessageUtils;
import ru.dlabs71.library.email.util.JavaCoreUtils;

public final class BaseMessageConverter {
    private static final Logger log = LoggerFactory.getLogger(BaseMessageConverter.class);

    public static BaseMessage convert(Message message) {
        log.debug("Starts convert jakarta Message to BaseMessage. Jakarta Message is {}", (Object)message);
        if (message == null) {
            return null;
        }
        BaseMessage baseMessage = BaseMessageConverter.convertEnvelopData(message);
        MessagePartConverter.ContentAndAttachments data = MessagePartConverter.getContent((Part)message);
        List<ContentMessage> textContents = data.getContentByType("text/plain");
        List<ContentMessage> htmlContents = data.getContentByType("text/html");
        baseMessage.setContents(textContents);
        baseMessage.addAllContent(htmlContents);
        baseMessage.setAttachments(data.getAttachments());
        log.debug("BaseMessage has: text contents are {}, html contents are {} and attachments are {}", new Object[]{textContents.size(), htmlContents.size(), data.getAttachments().size()});
        return baseMessage;
    }

    public static DefaultIncomingMessage convertToIncomingMessage(Message message) {
        if (message == null) {
            return null;
        }
        BaseMessage baseMessage = BaseMessageConverter.convert(message);
        return new DefaultIncomingMessage(baseMessage);
    }

    public static BaseMessage convertEnvelopData(Message message) {
        Address[] froms;
        log.debug("Starts convert content Jakarta Message to envelop of BaseMessage.");
        if (message == null) {
            return null;
        }
        BaseMessage baseMessage = new BaseMessage();
        baseMessage.setId(message.getMessageNumber());
        baseMessage.setRecipients(MessagePartConverter.getRecipients(message));
        try {
            if (message.getSubject() != null) {
                String decodedSubject = EmailMessageUtils.decodeData(message.getSubject());
                baseMessage.setSubject(decodedSubject);
            }
        }
        catch (MessagingException e) {
            throw new CheckEmailException("The attempt to get recipients of the message has failed: " + e.getMessage());
        }
        log.debug("Subject converted successfully");
        try {
            froms = message.getFrom();
        }
        catch (MessagingException e) {
            throw new CheckEmailException("The attempt to get senders of the message has failed: " + e.getMessage());
        }
        if (froms != null && froms.length > 0) {
            InternetAddress internetAddress = (InternetAddress)froms[0];
            baseMessage.setSender(new EmailParticipant(internetAddress.getAddress(), internetAddress.getPersonal()));
            log.debug("Sender converted successfully. The size of the list of senders is {}", (Object)froms.length);
        }
        try {
            baseMessage.setSeen(message.isSet(Flags.Flag.SEEN));
            log.debug("Seen flag converted successfully");
        }
        catch (MessagingException e) {
            log.warn("It is impossible to determine whether a message has been flagged as seen. " + e.getMessage());
        }
        try {
            String transferEncoder = ((MimeMessage)message).getHeader("Content-Transfer-Encoding", null);
            baseMessage.setTransferEncoder(TransferEncoder.forName(transferEncoder));
            log.debug("Transfer encoding converted successfully. Transfer Encoding is {}", (Object)transferEncoder);
            if (message instanceof IMAPMessage) {
                baseMessage.setSize(((IMAPMessage)message).getSizeLong());
            } else {
                baseMessage.setSize(Long.valueOf(message.getSize()));
            }
            log.debug("Size of message converted successfully. Size is {}", (Object)baseMessage.getSize());
            if (message.getSentDate() != null) {
                baseMessage.setSentDate(JavaCoreUtils.convert(message.getSentDate()));
            }
            log.debug("Sent date of message converted successfully. Sent date is {}", (Object)baseMessage.getSentDate());
            if (message.getReceivedDate() != null) {
                baseMessage.setReceivedDate(JavaCoreUtils.convert(message.getReceivedDate()));
            }
            log.debug("Received date of message converted successfully. Received date is {}", (Object)baseMessage.getReceivedDate());
        }
        catch (MessagingException e) {
            throw new CheckEmailException("The attempt to get recipients of the message has failed: " + e.getMessage());
        }
        log.debug("The envelop of the message created successfully");
        return baseMessage;
    }

    private BaseMessageConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

