/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.converter.incoming;

import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.ParseException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.dlabs71.library.email.dto.message.common.ContentMessage;
import ru.dlabs71.library.email.dto.message.common.EmailAttachment;
import ru.dlabs71.library.email.dto.message.common.EmailParticipant;
import ru.dlabs71.library.email.exception.CheckEmailException;
import ru.dlabs71.library.email.exception.ReadMessageException;
import ru.dlabs71.library.email.type.AttachmentType;
import ru.dlabs71.library.email.util.EmailMessageUtils;
import ru.dlabs71.library.email.util.JavaCoreUtils;

public final class MessagePartConverter {
    private static final Logger log = LoggerFactory.getLogger(MessagePartConverter.class);

    public static Set<EmailParticipant> getRecipients(Message message) {
        if (message == null) {
            return null;
        }
        try {
            Address[] recipients = message.getRecipients(Message.RecipientType.TO);
            log.debug("Starts converting email recipients. Count of the recipients is {}", recipients != null ? Integer.valueOf(recipients.length) : null);
            if (recipients == null || recipients.length == 0) {
                return new HashSet<EmailParticipant>();
            }
            return Arrays.stream(recipients).map(address -> {
                if (address instanceof InternetAddress) {
                    InternetAddress internetAddress = (InternetAddress)address;
                    return new EmailParticipant(internetAddress.getAddress(), internetAddress.getPersonal());
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        catch (MessagingException e) {
            throw new CheckEmailException("The attempt to get recipients of the message has failed: " + e.getMessage(), e);
        }
    }

    public static EmailAttachment getAttachment(Part part) {
        log.debug("Starts converting attachment from the Part {}", (Object)part);
        if (part == null) {
            return null;
        }
        try {
            byte[] content = MessagePartConverter.getContentDefaultAsBytes(part);
            log.debug("Content length of the part message: {}", (Object)content.length);
            return EmailAttachment.builder().name(EmailMessageUtils.decodeData(part.getFileName())).data(content).type(AttachmentType.find(part.getContentType())).contentType(EmailMessageUtils.decodeData(part.getContentType())).size(content.length).build();
        }
        catch (MessagingException e) {
            throw new ReadMessageException("An error occurred in getting attachments from the message: " + e.getMessage(), e);
        }
    }

    public static ContentAndAttachments getContent(Part part) {
        ContentAndAttachments result = new ContentAndAttachments();
        MessagePartConverter.getContent(part, result);
        return result;
    }

    public static void getContent(Part part, ContentAndAttachments result) {
        log.debug("Gets content from the email part {} and with result {}", (Object)part, (Object)result);
        if (part == null) {
            return;
        }
        try {
            part.getContent();
        }
        catch (MessagingException e) {
            throw new ReadMessageException("An error occurred in getting content from the message: " + e.getMessage(), e);
        }
        catch (IOException e) {
            log.warn(e.getMessage());
            log.debug("The part is empty.");
            return;
        }
        try {
            EmailAttachment attachment;
            if (!"attachment".equals(part.getDisposition())) {
                log.debug("The part is content. Part mime type is {}", (Object)part.getContentType());
                if (part.isMimeType("text/*")) {
                    result.addContent(part.getContentType(), (String)part.getContent());
                    return;
                }
                if (part.isMimeType("message/rfc822")) {
                    MessagePartConverter.getContent((Part)((Message)part.getContent()), result);
                    return;
                }
                if (part.isMimeType("multipart/*")) {
                    Multipart mp = (Multipart)part.getContent();
                    int count = mp.getCount();
                    for (int i = 0; i < count; ++i) {
                        MessagePartConverter.getContent((Part)mp.getBodyPart(i), result);
                    }
                    return;
                }
            }
            log.debug("The part is attachment with content type {}", (Object)part.getContentType());
            if (!AttachmentType.UNKNOWN.equals((Object)AttachmentType.find(part.getContentType())) && (attachment = MessagePartConverter.getAttachment(part)) != null) {
                result.addAttachment(attachment);
                return;
            }
            log.debug("The part has an unknown content type. It'll be added as content.");
            result.addContent(part.getContentType(), MessagePartConverter.getContentDefault(part));
        }
        catch (MessagingException | IOException e) {
            throw new ReadMessageException("An error occurred in getting content from the message: " + e.getMessage(), e);
        }
    }

    public static String getContentDefault(Part part) {
        Object content;
        if (part == null) {
            return null;
        }
        try {
            content = part.getContent();
        }
        catch (IOException ex) {
            log.warn(ex.getMessage());
            return null;
        }
        catch (MessagingException ex) {
            throw new ReadMessageException("An error occurred in getting content from the message: " + ex.getMessage(), ex);
        }
        log.debug("Got an object content from the part. It instances of {}", content.getClass());
        if (content instanceof String) {
            return (String)content;
        }
        if (content instanceof InputStream) {
            InputStream is = (InputStream)content;
            return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            part.writeTo((OutputStream)bos);
            bos.close();
            return bos.toString(StandardCharsets.UTF_8.name());
        }
        catch (MessagingException | IOException e) {
            throw new ReadMessageException("An error occurred in writing content to ByteArrayOutputStream: " + e.getMessage(), e);
        }
    }

    public static byte[] getContentDefaultAsBytes(Part bodyPart) {
        Object content;
        if (bodyPart == null) {
            return new byte[0];
        }
        try {
            content = bodyPart.getContent();
        }
        catch (IOException ex) {
            log.warn(ex.getMessage());
            return new byte[0];
        }
        catch (MessagingException ex) {
            throw new ReadMessageException("An error occurred in getting content from the message: " + ex.getMessage(), ex);
        }
        if (content instanceof String) {
            return ((String)content).getBytes(StandardCharsets.UTF_8);
        }
        if (content instanceof InputStream) {
            InputStream is = (InputStream)content;
            try {
                return JavaCoreUtils.toByteArray(is);
            }
            catch (IOException e) {
                throw new ReadMessageException("An error occurred while reading the input stream of the message: " + e.getMessage(), e);
            }
        }
        return content.toString().getBytes(StandardCharsets.UTF_8);
    }

    private MessagePartConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Content {
        private String contentType;
        private String data;

        public boolean isMimeType(String contentTypePattern) {
            try {
                return new ContentType(contentTypePattern).match(this.contentType);
            }
            catch (ParseException e) {
                return this.contentType.contains(contentTypePattern);
            }
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getData() {
            return this.data;
        }

        public Content(String contentType, String data) {
            this.contentType = contentType;
            this.data = data;
        }
    }

    public static class ContentAndAttachments {
        private final List<Content> contents = new ArrayList<Content>();
        private final List<EmailAttachment> attachments = new ArrayList<EmailAttachment>();

        public void addContent(String contentType, String data) {
            this.contents.add(new Content(contentType, data));
        }

        public void addAttachment(EmailAttachment attachment) {
            this.attachments.add(attachment);
        }

        public List<ContentMessage> getContentByType(String contentType) {
            return this.contents.stream().filter(item -> item.isMimeType(contentType)).map(item -> new ContentMessage(item.getData(), item.getContentType())).collect(Collectors.toList());
        }

        public boolean isEmpty() {
            return this.contents.isEmpty() && this.attachments.isEmpty();
        }

        public String toString() {
            return "ContentAndAttachments{contentsSize=" + this.contents.size() + ", attachmentsSize=" + this.attachments.size() + '}';
        }

        public List<Content> getContents() {
            return this.contents;
        }

        public List<EmailAttachment> getAttachments() {
            return this.attachments;
        }
    }
}

