/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.converter.incoming;

import jakarta.mail.Address;
import jakarta.mail.Flags;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import org.eclipse.angus.mail.imap.IMAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.dlabs71.library.email.converter.incoming.MessagePartConverter;
import ru.dlabs71.library.email.dto.message.common.EmailParticipant;
import ru.dlabs71.library.email.dto.message.incoming.MessageView;
import ru.dlabs71.library.email.exception.CheckEmailException;
import ru.dlabs71.library.email.type.TransferEncoder;
import ru.dlabs71.library.email.util.EmailMessageUtils;
import ru.dlabs71.library.email.util.JavaCoreUtils;

public final class MessageViewConverter {
    private static final Logger log = LoggerFactory.getLogger(MessageViewConverter.class);

    public static MessageView convert(Message message) {
        Address[] froms;
        log.debug("Starts converting jakarta Message to MessageView. Jakarta Message is {}", (Object)message);
        if (message == null) {
            return null;
        }
        MessageView.MessageViewBuilder builder = MessageView.builder();
        builder.id(message.getMessageNumber());
        builder.recipients(MessagePartConverter.getRecipients(message));
        log.debug("Recipients converted successfully");
        try {
            if (message.getSubject() != null) {
                String decodedSubject = EmailMessageUtils.decodeData(message.getSubject());
                builder.subject(decodedSubject);
            }
        }
        catch (MessagingException e) {
            throw new CheckEmailException("The attempt to get recipients of the message has failed: " + e.getMessage());
        }
        log.debug("Subject converted successfully");
        try {
            froms = message.getFrom();
        }
        catch (MessagingException e) {
            throw new CheckEmailException("The attempt to get senders of the message has failed: " + e.getMessage());
        }
        if (froms != null && froms.length > 0) {
            InternetAddress internetAddress = (InternetAddress)froms[0];
            builder.sender(new EmailParticipant(internetAddress.getAddress(), internetAddress.getPersonal()));
            log.debug("Sender converted successfully. The size of the list of senders is {}", (Object)froms.length);
        }
        try {
            builder.seen(message.isSet(Flags.Flag.SEEN));
            log.debug("Seen flag converted successfully");
        }
        catch (MessagingException e) {
            log.warn("It is impossible to determine whether a message has been flagged as seen. " + e.getMessage());
        }
        try {
            String transferEncoder = ((MimeMessage)message).getHeader("Content-Transfer-Encoding", null);
            builder.transferEncoder(TransferEncoder.forName(transferEncoder));
            log.debug("Transfer encoding converted successfully. Transfer Encoding is {}", (Object)transferEncoder);
            long size = message instanceof IMAPMessage ? ((IMAPMessage)message).getSizeLong() : (long)message.getSize();
            builder.size(size);
            log.debug("Size of message converted successfully. Size is {}", (Object)size);
            if (message.getSentDate() != null) {
                builder.sentDate(JavaCoreUtils.convert(message.getSentDate()));
            }
            log.debug("Sent date of message converted successfully");
            if (message.getReceivedDate() != null) {
                builder.receivedDate(JavaCoreUtils.convert(message.getReceivedDate()));
            }
            log.debug("Received date of message converted successfully");
        }
        catch (MessagingException e) {
            throw new CheckEmailException("The attempt to get recipients of the message has failed: " + e.getMessage());
        }
        return builder.build();
    }

    private MessageViewConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

