/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.converter.outgoing;

import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.dlabs71.library.email.converter.outgoing.JakartaMessagePartConverter;
import ru.dlabs71.library.email.dto.message.outgoing.OutgoingMessage;
import ru.dlabs71.library.email.exception.CreateMessageException;
import ru.dlabs71.library.email.util.EmailMessageUtils;
import ru.dlabs71.library.email.util.JavaCoreUtils;

public final class JakartaMessageConverter {
    private static final Logger log = LoggerFactory.getLogger(JakartaMessageConverter.class);

    public static Message convert(OutgoingMessage message, Session session, String emailFrom, String nameFrom) throws CreateMessageException, MessagingException {
        if (message == null) {
            return null;
        }
        JavaCoreUtils.notNullArgument(session, "session");
        JavaCoreUtils.notNullArgument(emailFrom, "emailFrom");
        log.debug("Starts converting outgoing message to jakarta Message. Email = {}, Name = {}, Message class = {}", new Object[]{emailFrom, nameFrom, message.getClass()});
        MimeMultipart multipart = new MimeMultipart();
        List<BodyPart> parts = JakartaMessagePartConverter.convertBodyPart(message);
        for (BodyPart bodyPart : parts) {
            multipart.addBodyPart(bodyPart);
        }
        log.debug("Converts message contents successfully. Size is {}", (Object)parts.size());
        List<BodyPart> attachments = JakartaMessagePartConverter.convertAttachmentParts(message);
        if (attachments != null) {
            for (BodyPart attachment : attachments) {
                multipart.addBodyPart(attachment);
            }
        }
        log.debug("Converts message attachments successfully. Size is {}", (Object)attachments.size());
        MimeMessage mimeMessage = JakartaMessageConverter.createEnvelop(message, session, emailFrom, nameFrom);
        mimeMessage.setContent((Multipart)multipart);
        mimeMessage.addHeader("Content-Transfer-Encoding", message.getTransferEncoder().getName());
        return mimeMessage;
    }

    public static MimeMessage createEnvelop(OutgoingMessage message, Session session, String emailFrom, String nameFrom) throws CreateMessageException {
        if (message == null) {
            return null;
        }
        JavaCoreUtils.notNullArgument(session, "session");
        JavaCoreUtils.notNullArgument(emailFrom, "emailFrom");
        try {
            MimeMessage envelop = new MimeMessage(session);
            envelop.setFrom((Address)EmailMessageUtils.createAddress(emailFrom, nameFrom));
            envelop.setSubject(message.getSubject());
            envelop.setSentDate(new Date());
            envelop.setRecipients(Message.RecipientType.TO, (Address[])EmailMessageUtils.createAddresses(message.getRecipients()));
            return envelop;
        }
        catch (MessagingException | UnsupportedEncodingException ex) {
            throw new CreateMessageException("Message object couldn't be created due to the following error: " + ex.getMessage(), ex);
        }
    }

    private JakartaMessageConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

