/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.converter.outgoing;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.util.ByteArrayDataSource;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import ru.dlabs71.library.email.dto.message.common.ContentMessage;
import ru.dlabs71.library.email.dto.message.common.EmailAttachment;
import ru.dlabs71.library.email.dto.message.outgoing.OutgoingMessage;
import ru.dlabs71.library.email.exception.CreateMessageException;

public final class JakartaMessagePartConverter {
    public static List<BodyPart> convertBodyPart(OutgoingMessage message) throws CreateMessageException {
        if (message == null || message.getContents() == null || message.getContents().isEmpty()) {
            return Collections.emptyList();
        }
        return message.getContents().stream().map(JakartaMessagePartConverter::convertBodyPart).collect(Collectors.toList());
    }

    public static BodyPart convertBodyPart(ContentMessage content) throws CreateMessageException {
        if (content == null) {
            return null;
        }
        try {
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(content.getData());
            messageBodyPart.setHeader("Content-type", content.getContentType());
            return messageBodyPart;
        }
        catch (MessagingException ex) {
            throw new CreateMessageException("Body part couldn't be created due to the following error: " + ex.getMessage(), ex);
        }
    }

    public static List<BodyPart> convertAttachmentParts(OutgoingMessage message) throws CreateMessageException {
        if (message == null || message.getAttachments() == null || message.getAttachments().isEmpty()) {
            return Collections.emptyList();
        }
        return message.getAttachments().stream().map(JakartaMessagePartConverter::convertAttachmentPart).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static BodyPart convertAttachmentPart(EmailAttachment attachment) throws CreateMessageException {
        if (attachment == null || attachment.getData() == null || attachment.getData().length == 0) {
            return null;
        }
        try {
            MimeBodyPart attachmentPart = new MimeBodyPart();
            ByteArrayDataSource dataSource = new ByteArrayDataSource(attachment.getData(), attachment.getContentType());
            attachmentPart.setDataHandler(new DataHandler((DataSource)dataSource));
            attachmentPart.setFileName(attachment.getName());
            attachmentPart.setHeader("Content-type", attachment.getContentType());
            return attachmentPart;
        }
        catch (MessagingException e) {
            throw new CreateMessageException("Body part couldn't be created due to the following error: " + e.getMessage(), e);
        }
    }

    private JakartaMessagePartConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

