/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.dto.message.common;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ru.dlabs71.library.email.dto.message.common.ContentMessage;
import ru.dlabs71.library.email.dto.message.common.EmailAttachment;
import ru.dlabs71.library.email.dto.message.common.EmailParticipant;
import ru.dlabs71.library.email.dto.message.common.Message;
import ru.dlabs71.library.email.type.TransferEncoder;

public class BaseMessage
implements Message {
    private Integer id;
    private String subject;
    private List<ContentMessage> contents = new ArrayList<ContentMessage>();
    private Set<EmailParticipant> recipients = new HashSet<EmailParticipant>();
    private EmailParticipant sender = null;
    private List<EmailAttachment> attachments = new ArrayList<EmailAttachment>();
    private TransferEncoder transferEncoder = TransferEncoder.byDefault();
    private Long size = 0L;
    private boolean seen = false;
    private LocalDateTime sentDate;
    private LocalDateTime receivedDate;

    public void addContent(ContentMessage content) {
        if (this.contents == null) {
            this.contents = new ArrayList<ContentMessage>();
        }
        this.contents.add(content);
    }

    public void addAllContent(Collection<ContentMessage> contents) {
        if (this.contents == null) {
            this.contents = new ArrayList<ContentMessage>();
        }
        this.contents.addAll(contents);
    }

    public String getAllContentsAsString() {
        return this.getAllContentsAsString("\n");
    }

    public String getAllContentsAsString(String delimiter) {
        return this.getContents().stream().map(ContentMessage::getData).collect(Collectors.joining(delimiter));
    }

    public String toString() {
        return "BaseMessage{subject='" + this.subject + '\'' + ", content=" + this.contents + ", recipients=" + this.recipients + ", sender=" + this.sender + ", attachments=" + this.attachments + ", transferEncoder=" + (Object)((Object)this.transferEncoder) + '}';
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setContents(List<ContentMessage> contents) {
        this.contents = contents;
    }

    public void setRecipients(Set<EmailParticipant> recipients) {
        this.recipients = recipients;
    }

    public void setSender(EmailParticipant sender) {
        this.sender = sender;
    }

    public void setAttachments(List<EmailAttachment> attachments) {
        this.attachments = attachments;
    }

    public void setTransferEncoder(TransferEncoder transferEncoder) {
        this.transferEncoder = transferEncoder;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public void setSeen(boolean seen) {
        this.seen = seen;
    }

    public void setSentDate(LocalDateTime sentDate) {
        this.sentDate = sentDate;
    }

    public void setReceivedDate(LocalDateTime receivedDate) {
        this.receivedDate = receivedDate;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public List<ContentMessage> getContents() {
        return this.contents;
    }

    @Override
    public Set<EmailParticipant> getRecipients() {
        return this.recipients;
    }

    @Override
    public EmailParticipant getSender() {
        return this.sender;
    }

    @Override
    public List<EmailAttachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public TransferEncoder getTransferEncoder() {
        return this.transferEncoder;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    @Override
    public boolean isSeen() {
        return this.seen;
    }

    @Override
    public LocalDateTime getSentDate() {
        return this.sentDate;
    }

    @Override
    public LocalDateTime getReceivedDate() {
        return this.receivedDate;
    }

    public BaseMessage() {
    }

    public BaseMessage(Integer id, String subject, List<ContentMessage> contents, Set<EmailParticipant> recipients, EmailParticipant sender, List<EmailAttachment> attachments, TransferEncoder transferEncoder, Long size, boolean seen, LocalDateTime sentDate, LocalDateTime receivedDate) {
        this.id = id;
        this.subject = subject;
        this.contents = contents;
        this.recipients = recipients;
        this.sender = sender;
        this.attachments = attachments;
        this.transferEncoder = transferEncoder;
        this.size = size;
        this.seen = seen;
        this.sentDate = sentDate;
        this.receivedDate = receivedDate;
    }
}

