/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.dto.message.common;

import java.nio.charset.Charset;
import ru.dlabs71.library.email.type.ContentMessageType;
import ru.dlabs71.library.email.util.ProtocolUtils;

public class ContentMessage {
    private final String data;
    private final Charset charset;
    private final ContentMessageType type;
    private final Integer size;
    private final String contentType;

    public ContentMessage(String data, String contentType) {
        this.data = data;
        this.contentType = contentType;
        this.type = ContentMessageType.forContentType(contentType);
        String charset = ProtocolUtils.defineCharsetFromHeaderValue(contentType);
        this.charset = charset != null ? Charset.forName(charset) : Charset.defaultCharset();
        this.size = data.getBytes(this.charset).length;
    }

    public ContentMessage(String data, String contentType, Charset charset) {
        this.data = data;
        this.contentType = charset != null ? ProtocolUtils.contentTypeWithCharset(contentType, charset) : contentType;
        this.type = ContentMessageType.forContentType(contentType);
        this.charset = charset == null ? Charset.defaultCharset() : charset;
        this.size = data.getBytes(this.charset).length;
    }

    public String toString() {
        return "ContentMessage{, charset=" + this.charset + ", size=" + this.size + ", contentType='" + this.contentType + '\'' + '}';
    }

    public String getData() {
        return this.data;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public ContentMessageType getType() {
        return this.type;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getContentType() {
        return this.contentType;
    }
}

