/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.dto.message.common;

import java.util.Arrays;
import ru.dlabs71.library.email.type.AttachmentType;

public class EmailAttachment {
    private final String name;
    private final byte[] data;
    private final AttachmentType type;
    private final String contentType;
    private final Integer size;

    public String toString() {
        return "EmailAttachment{name='" + this.name + '\'' + ", contentType='" + this.contentType + '\'' + ", size=" + this.size + '}';
    }

    EmailAttachment(String name, byte[] data, AttachmentType type, String contentType, Integer size) {
        this.name = name;
        this.data = data;
        this.type = type;
        this.contentType = contentType;
        this.size = size;
    }

    public static EmailAttachmentBuilder builder() {
        return new EmailAttachmentBuilder();
    }

    public String getName() {
        return this.name;
    }

    public byte[] getData() {
        return this.data;
    }

    public AttachmentType getType() {
        return this.type;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Integer getSize() {
        return this.size;
    }

    public static class EmailAttachmentBuilder {
        private String name;
        private byte[] data;
        private AttachmentType type;
        private String contentType;
        private Integer size;

        EmailAttachmentBuilder() {
        }

        public EmailAttachmentBuilder name(String name) {
            this.name = name;
            return this;
        }

        public EmailAttachmentBuilder data(byte[] data) {
            this.data = data;
            return this;
        }

        public EmailAttachmentBuilder type(AttachmentType type) {
            this.type = type;
            return this;
        }

        public EmailAttachmentBuilder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public EmailAttachmentBuilder size(Integer size) {
            this.size = size;
            return this;
        }

        public EmailAttachment build() {
            return new EmailAttachment(this.name, this.data, this.type, this.contentType, this.size);
        }

        public String toString() {
            return "EmailAttachment.EmailAttachmentBuilder(name=" + this.name + ", data=" + Arrays.toString(this.data) + ", type=" + (Object)((Object)this.type) + ", contentType=" + this.contentType + ", size=" + this.size + ")";
        }
    }
}

