/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.dto.message.common;

import jakarta.mail.internet.MimeUtility;
import java.io.UnsupportedEncodingException;
import ru.dlabs71.library.email.exception.ValidationMessageException;

public class EmailParticipant {
    private static final String rfc822phrase = "()<>@,;:\\\"\t .[]".replace(' ', '\u0000').replace('\t', '\u0000');
    private final String email;
    private final String name;
    private String displayViewCache;

    public EmailParticipant(String email) {
        if (email == null) {
            throw new ValidationMessageException("The recipient's email must not be null");
        }
        this.email = email;
        this.name = null;
    }

    public EmailParticipant(String email, String name) {
        if (email == null) {
            throw new ValidationMessageException("The recipient's email must not be null");
        }
        this.email = email;
        this.name = name;
    }

    public static EmailParticipant of(String email, String name) {
        return new EmailParticipant(email, name);
    }

    public static EmailParticipant of(String email) {
        return new EmailParticipant(email);
    }

    public String toString() {
        if (this.displayViewCache != null) {
            return this.displayViewCache;
        }
        String encodedName = this.name;
        if (this.name != null) {
            try {
                encodedName = MimeUtility.encodeWord((String)this.name);
            }
            catch (UnsupportedEncodingException ignored) {
                encodedName = this.name;
            }
        }
        this.displayViewCache = encodedName != null ? MimeUtility.quote((String)encodedName, (String)rfc822phrase) + " <" + this.email + ">" : "<" + this.email + ">";
        return this.displayViewCache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmailParticipant)) {
            return false;
        }
        EmailParticipant other = (EmailParticipant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        return !(this$email == null ? other$email != null : !this$email.equals(other$email));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmailParticipant;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        return result;
    }

    public String getEmail() {
        return this.email;
    }

    public String getName() {
        return this.name;
    }
}

