/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.dto.message.incoming;

import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import ru.dlabs71.library.email.dto.message.common.BaseMessage;
import ru.dlabs71.library.email.dto.message.common.ContentMessage;
import ru.dlabs71.library.email.dto.message.incoming.IncomingMessage;
import ru.dlabs71.library.email.type.ContentMessageType;

public class DefaultIncomingMessage
extends BaseMessage
implements IncomingMessage {
    public DefaultIncomingMessage(@NonNull BaseMessage baseMessage) {
        super(baseMessage.getId(), baseMessage.getSubject(), baseMessage.getContents(), baseMessage.getRecipients(), baseMessage.getSender(), baseMessage.getAttachments(), baseMessage.getTransferEncoder(), baseMessage.getSize(), baseMessage.isSeen(), baseMessage.getSentDate(), baseMessage.getReceivedDate());
        if (baseMessage == null) {
            throw new NullPointerException("baseMessage is marked non-null but is null");
        }
    }

    @Override
    public List<ContentMessage> getHtmlContents() {
        return this.getContents().stream().filter(item -> ContentMessageType.HTML.equals((Object)item.getType())).collect(Collectors.toList());
    }

    @Override
    public List<ContentMessage> getTextContents() {
        return this.getContents().stream().filter(item -> ContentMessageType.TEXT.equals((Object)item.getType())).collect(Collectors.toList());
    }

    @Override
    public String getHtmlContentsAsString() {
        return this.getHtmlContentsAsString("\n");
    }

    @Override
    public String getHtmlContentsAsString(String delimiter) {
        return this.getHtmlContents().stream().map(ContentMessage::getData).collect(Collectors.joining(delimiter));
    }

    @Override
    public String getTextContentsAsString() {
        return this.getTextContentsAsString("\n");
    }

    @Override
    public String getTextContentsAsString(String delimiter) {
        return this.getTextContents().stream().map(ContentMessage::getData).collect(Collectors.joining(delimiter));
    }
}

