/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.dto.message.outgoing;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.dlabs71.library.email.dto.message.common.BaseMessage;
import ru.dlabs71.library.email.dto.message.common.ContentMessage;
import ru.dlabs71.library.email.dto.message.common.EmailAttachment;
import ru.dlabs71.library.email.dto.message.common.EmailParticipant;
import ru.dlabs71.library.email.dto.message.outgoing.OutgoingMessage;
import ru.dlabs71.library.email.type.ContentMessageType;
import ru.dlabs71.library.email.type.TransferEncoder;

public class DefaultOutgoingMessage
extends BaseMessage
implements OutgoingMessage {
    public DefaultOutgoingMessage(String subject, String content, Set<EmailParticipant> recipientEmail, List<EmailAttachment> attachments) {
        this(subject, content, Charset.defaultCharset(), ContentMessageType.TEXT, recipientEmail == null ? Collections.emptySet() : recipientEmail, attachments == null ? Collections.emptyList() : attachments, TransferEncoder.byDefault());
    }

    public DefaultOutgoingMessage(String subject, String content, Charset charsetContent, ContentMessageType contentType, Set<EmailParticipant> recipientEmail, List<EmailAttachment> attachments, TransferEncoder transferEncoder) {
        this.setSubject(subject);
        this.setTransferEncoder(transferEncoder == null ? TransferEncoder.byDefault() : transferEncoder);
        this.setRecipients(recipientEmail);
        this.setAttachments(attachments);
        if (content != null) {
            ContentMessage contentMessage = new ContentMessage(content, contentType.getMimeType(), charsetContent);
            this.addContent(contentMessage);
        } else {
            this.setContents(new ArrayList<ContentMessage>());
        }
    }

    public DefaultOutgoingMessage(String subject, List<ContentMessage> contents, Set<EmailParticipant> recipientEmail, List<EmailAttachment> attachments, TransferEncoder transferEncoder) {
        this.setSubject(subject);
        this.setTransferEncoder(transferEncoder == null ? TransferEncoder.byDefault() : transferEncoder);
        this.setRecipients(recipientEmail);
        this.setAttachments(attachments);
        if (contents != null) {
            this.addAllContent(contents);
        } else {
            this.setContents(new ArrayList<ContentMessage>());
        }
    }

    public static Builder outgoingMessageBuilder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return "DefaultOutgoingMessage." + super.toString();
    }

    public static class Builder {
        private String subject;
        private String content;
        private Charset charsetContent = Charset.defaultCharset();
        private ContentMessageType contentType;
        private TransferEncoder transferEncoder = TransferEncoder.byDefault();
        private Set<EmailParticipant> recipientEmail = new HashSet<EmailParticipant>();
        private List<EmailAttachment> attachments = new ArrayList<EmailAttachment>();
        private List<ContentMessage> contents = new ArrayList<ContentMessage>();

        public DefaultOutgoingMessage build() {
            if (this.content != null) {
                this.contents.add(new ContentMessage(this.content, this.contentType.getMimeType(), this.charsetContent));
            }
            return new DefaultOutgoingMessage(this.subject, this.contents, this.recipientEmail, this.attachments, this.transferEncoder);
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder charsetContent(Charset charsetContent) {
            this.charsetContent = charsetContent;
            return this;
        }

        public Builder transferEncoder(TransferEncoder encoding) {
            this.transferEncoder = encoding;
            return this;
        }

        public Builder contentType(ContentMessageType contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder recipientEmail(Set<EmailParticipant> recipientEmail) {
            this.recipientEmail = recipientEmail;
            return this;
        }

        public Builder attachments(List<EmailAttachment> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder addAttachment(EmailAttachment attachment) {
            if (this.attachments == null) {
                this.attachments = new ArrayList<EmailAttachment>();
            }
            this.attachments.add(attachment);
            return this;
        }

        public Builder addContent(ContentMessage contentMessage) {
            if (this.contents == null) {
                this.contents = new ArrayList<ContentMessage>();
            }
            this.contents.add(contentMessage);
            return this;
        }

        public String toString() {
            return "DefaultOutgoingMessage.Builder(subject=" + this.subject + ", content=" + this.content + ", charsetContent=" + this.charsetContent + ", contentType=" + (Object)((Object)this.contentType) + ", transferEncoder=" + (Object)((Object)this.transferEncoder) + ", recipientEmail=" + this.recipientEmail + ", attachments=" + this.attachments + ", contents=" + this.contents + ")";
        }
    }
}

