/*
 * Decompiled with CFR 0.152.
 */
package ru.dlabs71.library.email.dto.message.outgoing;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.dlabs71.library.email.dto.message.common.ContentMessage;
import ru.dlabs71.library.email.dto.message.common.EmailAttachment;
import ru.dlabs71.library.email.dto.message.common.EmailParticipant;
import ru.dlabs71.library.email.dto.message.outgoing.DefaultOutgoingMessage;
import ru.dlabs71.library.email.exception.TemplateCreationException;
import ru.dlabs71.library.email.type.ContentMessageType;
import ru.dlabs71.library.email.type.TransferEncoder;
import ru.dlabs71.library.email.util.TemplateUtils;

public class TemplatedOutgoingMessage
extends DefaultOutgoingMessage {
    private final String pathToTemplate;
    private final Map<String, Object> params;
    private final ContentMessageType contentType;

    public TemplatedOutgoingMessage(String subject, String pathToTemplate, Map<String, Object> params, Set<EmailParticipant> recipientEmail) throws TemplateCreationException {
        this(subject, pathToTemplate, params, null, ContentMessageType.HTML, recipientEmail, null, null);
    }

    public TemplatedOutgoingMessage(String subject, String pathToTemplate, Map<String, Object> params, Set<EmailParticipant> recipientEmail, List<EmailAttachment> attachments) throws TemplateCreationException {
        this(subject, pathToTemplate, params, null, ContentMessageType.HTML, recipientEmail, attachments, null);
    }

    public TemplatedOutgoingMessage(String subject, String pathToTemplate, Map<String, Object> params, Charset charsetContent, ContentMessageType contentType, Set<EmailParticipant> recipientEmail) throws TemplateCreationException {
        this(subject, pathToTemplate, params, charsetContent, contentType, recipientEmail, null, null);
    }

    public TemplatedOutgoingMessage(String subject, String pathToTemplate, Map<String, Object> params, Charset charsetContent, ContentMessageType contentType, Set<EmailParticipant> recipientEmail, List<EmailAttachment> attachments, TransferEncoder transferEncoder) throws TemplateCreationException {
        super(subject, null, charsetContent, contentType, recipientEmail, attachments, transferEncoder);
        this.pathToTemplate = pathToTemplate;
        this.params = params;
        this.contentType = contentType;
        String content = this.constructContent(this.pathToTemplate, this.params);
        if (content != null) {
            this.addContent(new ContentMessage(content, contentType.getMimeType(), charsetContent));
        }
    }

    public static TemplatedMessageBuilder builder() {
        return new TemplatedMessageBuilder();
    }

    protected String constructContent(String path, Map<String, Object> params) throws TemplateCreationException {
        if (path == null || params == null) {
            return null;
        }
        return TemplateUtils.construct(path, params);
    }

    @Override
    public String toString() {
        return "TemplatedOutgoingMessage<" + this.pathToTemplate + ">." + super.toString();
    }

    public String getPathToTemplate() {
        return this.pathToTemplate;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public ContentMessageType getContentType() {
        return this.contentType;
    }

    public static class TemplatedMessageBuilder {
        private String pathToTemplate;
        private Map<String, Object> params = new HashMap<String, Object>();
        private String subject;
        private ContentMessageType contentType = ContentMessageType.HTML;
        private Set<EmailParticipant> recipientEmail = new HashSet<EmailParticipant>();
        private List<EmailAttachment> attachments = new ArrayList<EmailAttachment>();
        private Charset charsetContent = Charset.defaultCharset();
        private TransferEncoder transferEncoder = TransferEncoder.byDefault();

        public TemplatedOutgoingMessage build() throws TemplateCreationException {
            return new TemplatedOutgoingMessage(this.subject, this.pathToTemplate, this.params, this.charsetContent, this.contentType, this.recipientEmail, this.attachments, this.transferEncoder);
        }

        public TemplatedMessageBuilder template(String pathToTemplate, Map<String, Object> params) {
            this.pathToTemplate = pathToTemplate;
            this.params = params;
            return this;
        }

        public TemplatedMessageBuilder template(String pathToTemplate) {
            this.pathToTemplate = pathToTemplate;
            return this;
        }

        public TemplatedMessageBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public TemplatedMessageBuilder recipientEmail(Set<EmailParticipant> recipientEmail) {
            this.recipientEmail = recipientEmail;
            return this;
        }

        public TemplatedMessageBuilder attachments(List<EmailAttachment> attachments) {
            this.attachments = attachments;
            return this;
        }

        public TemplatedMessageBuilder contentType(ContentMessageType contentType) {
            this.contentType = contentType;
            return this;
        }

        public TemplatedMessageBuilder charsetContent(Charset charsetContent) {
            this.charsetContent = charsetContent;
            return this;
        }

        public TemplatedMessageBuilder transferEncoder(TransferEncoder transferEncoder) {
            this.transferEncoder = transferEncoder;
            return this;
        }

        public TemplatedMessageBuilder addAttachment(EmailAttachment attachment) {
            if (this.attachments == null) {
                this.attachments = new ArrayList<EmailAttachment>();
            }
            this.attachments.add(attachment);
            return this;
        }

        public String toString() {
            return "TemplatedOutgoingMessage.TemplatedMessageBuilder(pathToTemplate=" + this.pathToTemplate + ", params=" + this.params + ", subject=" + this.subject + ", contentType=" + (Object)((Object)this.contentType) + ", recipientEmail=" + this.recipientEmail + ", attachments=" + this.attachments + ", charsetContent=" + this.charsetContent + ", transferEncoder=" + (Object)((Object)this.transferEncoder) + ")";
        }
    }
}

